package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.config.model.primitives.{TagValue, TagKey}
import scala.jdk.CollectionConverters.*
final case class Tag(
    key: Option[TagKey] = None,
    value: Option[TagValue] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.config.model.Tag = {
    import Tag.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.Tag
      .builder()
      .optionallyWith(key.map(value => TagKey.unwrap(value): java.lang.String))(
        _.key
      )
      .optionallyWith(
        value.map(value => TagValue.unwrap(value): java.lang.String)
      )(_.value)
      .build()
  }
  def asReadOnly: zio.aws.config.model.Tag.ReadOnly =
    zio.aws.config.model.Tag.wrap(buildAwsValue())
}
object Tag {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.config.model.Tag] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.Tag = zio.aws.config.model
      .Tag(key.map(value => value), value.map(value => value))
    def key: Option[TagKey]
    def value: Option[TagValue]
    def getKey: ZIO[Any, AwsError, TagKey] =
      AwsError.unwrapOptionField("key", key)
    def getValue: ZIO[Any, AwsError, TagValue] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.Tag
  ) extends zio.aws.config.model.Tag.ReadOnly {
    override val key: Option[TagKey] = scala
      .Option(impl.key())
      .map(value => zio.aws.config.model.primitives.TagKey(value))
    override val value: Option[TagValue] = scala
      .Option(impl.value())
      .map(value => zio.aws.config.model.primitives.TagValue(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.Tag
  ): zio.aws.config.model.Tag.ReadOnly = new Wrapper(impl)
}
