package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.config.model.primitives.StringWithCharLimit256
import scala.jdk.CollectionConverters.*
final case class Source(
    owner: zio.aws.config.model.Owner,
    sourceIdentifier: Option[StringWithCharLimit256] = None,
    sourceDetails: Option[Iterable[zio.aws.config.model.SourceDetail]] = None,
    customPolicyDetails: Option[zio.aws.config.model.CustomPolicyDetails] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.config.model.Source = {
    import Source.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.Source
      .builder()
      .owner(owner.unwrap)
      .optionallyWith(
        sourceIdentifier.map(value =>
          StringWithCharLimit256.unwrap(value): java.lang.String
        )
      )(_.sourceIdentifier)
      .optionallyWith(
        sourceDetails.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.sourceDetails)
      .optionallyWith(customPolicyDetails.map(value => value.buildAwsValue()))(
        _.customPolicyDetails
      )
      .build()
  }
  def asReadOnly: zio.aws.config.model.Source.ReadOnly =
    zio.aws.config.model.Source.wrap(buildAwsValue())
}
object Source {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.config.model.Source] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.Source = zio.aws.config.model.Source(
      owner,
      sourceIdentifier.map(value => value),
      sourceDetails.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      customPolicyDetails.map(value => value.asEditable)
    )
    def owner: zio.aws.config.model.Owner
    def sourceIdentifier: Option[StringWithCharLimit256]
    def sourceDetails: Option[List[zio.aws.config.model.SourceDetail.ReadOnly]]
    def customPolicyDetails
        : Option[zio.aws.config.model.CustomPolicyDetails.ReadOnly]
    def getOwner: ZIO[Any, Nothing, zio.aws.config.model.Owner] =
      ZIO.succeed(owner)
    def getSourceIdentifier: ZIO[Any, AwsError, StringWithCharLimit256] =
      AwsError.unwrapOptionField("sourceIdentifier", sourceIdentifier)
    def getSourceDetails
        : ZIO[Any, AwsError, List[zio.aws.config.model.SourceDetail.ReadOnly]] =
      AwsError.unwrapOptionField("sourceDetails", sourceDetails)
    def getCustomPolicyDetails: ZIO[
      Any,
      AwsError,
      zio.aws.config.model.CustomPolicyDetails.ReadOnly
    ] = AwsError.unwrapOptionField("customPolicyDetails", customPolicyDetails)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.Source
  ) extends zio.aws.config.model.Source.ReadOnly {
    override val owner: zio.aws.config.model.Owner =
      zio.aws.config.model.Owner.wrap(impl.owner())
    override val sourceIdentifier: Option[StringWithCharLimit256] = scala
      .Option(impl.sourceIdentifier())
      .map(value =>
        zio.aws.config.model.primitives.StringWithCharLimit256(value)
      )
    override val sourceDetails
        : Option[List[zio.aws.config.model.SourceDetail.ReadOnly]] = scala
      .Option(impl.sourceDetails())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.config.model.SourceDetail.wrap(item)
        }.toList
      )
    override val customPolicyDetails
        : Option[zio.aws.config.model.CustomPolicyDetails.ReadOnly] = scala
      .Option(impl.customPolicyDetails())
      .map(value => zio.aws.config.model.CustomPolicyDetails.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.Source
  ): zio.aws.config.model.Source.ReadOnly = new Wrapper(impl)
}
