package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.config.model.primitives.{AccountId, OrganizationConfigRuleName}
import scala.jdk.CollectionConverters.*
final case class PutOrganizationConfigRuleRequest(
    organizationConfigRuleName: OrganizationConfigRuleName,
    organizationManagedRuleMetadata: Option[
      zio.aws.config.model.OrganizationManagedRuleMetadata
    ] = None,
    organizationCustomRuleMetadata: Option[
      zio.aws.config.model.OrganizationCustomRuleMetadata
    ] = None,
    excludedAccounts: Option[Iterable[AccountId]] = None,
    organizationCustomPolicyRuleMetadata: Option[
      zio.aws.config.model.OrganizationCustomPolicyRuleMetadata
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.PutOrganizationConfigRuleRequest = {
    import PutOrganizationConfigRuleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.PutOrganizationConfigRuleRequest
      .builder()
      .organizationConfigRuleName(
        OrganizationConfigRuleName.unwrap(
          organizationConfigRuleName
        ): java.lang.String
      )
      .optionallyWith(
        organizationManagedRuleMetadata.map(value => value.buildAwsValue())
      )(_.organizationManagedRuleMetadata)
      .optionallyWith(
        organizationCustomRuleMetadata.map(value => value.buildAwsValue())
      )(_.organizationCustomRuleMetadata)
      .optionallyWith(
        excludedAccounts.map(value =>
          value.map { item =>
            AccountId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.excludedAccounts)
      .optionallyWith(
        organizationCustomPolicyRuleMetadata.map(value => value.buildAwsValue())
      )(_.organizationCustomPolicyRuleMetadata)
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.PutOrganizationConfigRuleRequest.ReadOnly =
    zio.aws.config.model.PutOrganizationConfigRuleRequest.wrap(buildAwsValue())
}
object PutOrganizationConfigRuleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.PutOrganizationConfigRuleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.PutOrganizationConfigRuleRequest =
      zio.aws.config.model.PutOrganizationConfigRuleRequest(
        organizationConfigRuleName,
        organizationManagedRuleMetadata.map(value => value.asEditable),
        organizationCustomRuleMetadata.map(value => value.asEditable),
        excludedAccounts.map(value => value),
        organizationCustomPolicyRuleMetadata.map(value => value.asEditable)
      )
    def organizationConfigRuleName: OrganizationConfigRuleName
    def organizationManagedRuleMetadata
        : Option[zio.aws.config.model.OrganizationManagedRuleMetadata.ReadOnly]
    def organizationCustomRuleMetadata
        : Option[zio.aws.config.model.OrganizationCustomRuleMetadata.ReadOnly]
    def excludedAccounts: Option[List[AccountId]]
    def organizationCustomPolicyRuleMetadata: Option[
      zio.aws.config.model.OrganizationCustomPolicyRuleMetadata.ReadOnly
    ]
    def getOrganizationConfigRuleName
        : ZIO[Any, Nothing, OrganizationConfigRuleName] =
      ZIO.succeed(organizationConfigRuleName)
    def getOrganizationManagedRuleMetadata: ZIO[
      Any,
      AwsError,
      zio.aws.config.model.OrganizationManagedRuleMetadata.ReadOnly
    ] = AwsError.unwrapOptionField(
      "organizationManagedRuleMetadata",
      organizationManagedRuleMetadata
    )
    def getOrganizationCustomRuleMetadata: ZIO[
      Any,
      AwsError,
      zio.aws.config.model.OrganizationCustomRuleMetadata.ReadOnly
    ] = AwsError.unwrapOptionField(
      "organizationCustomRuleMetadata",
      organizationCustomRuleMetadata
    )
    def getExcludedAccounts: ZIO[Any, AwsError, List[AccountId]] =
      AwsError.unwrapOptionField("excludedAccounts", excludedAccounts)
    def getOrganizationCustomPolicyRuleMetadata: ZIO[
      Any,
      AwsError,
      zio.aws.config.model.OrganizationCustomPolicyRuleMetadata.ReadOnly
    ] = AwsError.unwrapOptionField(
      "organizationCustomPolicyRuleMetadata",
      organizationCustomPolicyRuleMetadata
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.PutOrganizationConfigRuleRequest
  ) extends zio.aws.config.model.PutOrganizationConfigRuleRequest.ReadOnly {
    override val organizationConfigRuleName: OrganizationConfigRuleName =
      zio.aws.config.model.primitives
        .OrganizationConfigRuleName(impl.organizationConfigRuleName())
    override val organizationManagedRuleMetadata: Option[
      zio.aws.config.model.OrganizationManagedRuleMetadata.ReadOnly
    ] = scala
      .Option(impl.organizationManagedRuleMetadata())
      .map(value =>
        zio.aws.config.model.OrganizationManagedRuleMetadata.wrap(value)
      )
    override val organizationCustomRuleMetadata
        : Option[zio.aws.config.model.OrganizationCustomRuleMetadata.ReadOnly] =
      scala
        .Option(impl.organizationCustomRuleMetadata())
        .map(value =>
          zio.aws.config.model.OrganizationCustomRuleMetadata.wrap(value)
        )
    override val excludedAccounts: Option[List[AccountId]] = scala
      .Option(impl.excludedAccounts())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.config.model.primitives.AccountId(item)
        }.toList
      )
    override val organizationCustomPolicyRuleMetadata: Option[
      zio.aws.config.model.OrganizationCustomPolicyRuleMetadata.ReadOnly
    ] = scala
      .Option(impl.organizationCustomPolicyRuleMetadata())
      .map(value =>
        zio.aws.config.model.OrganizationCustomPolicyRuleMetadata.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.PutOrganizationConfigRuleRequest
  ): zio.aws.config.model.PutOrganizationConfigRuleRequest.ReadOnly =
    new Wrapper(impl)
}
