package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class PutEvaluationsRequest(
    evaluations: Option[Iterable[zio.aws.config.model.Evaluation]] = None,
    resultToken: String,
    testMode: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.PutEvaluationsRequest = {
    import PutEvaluationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.PutEvaluationsRequest
      .builder()
      .optionallyWith(
        evaluations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.evaluations)
      .resultToken(resultToken: java.lang.String)
      .optionallyWith(testMode.map(value => value: java.lang.Boolean))(
        _.testMode
      )
      .build()
  }
  def asReadOnly: zio.aws.config.model.PutEvaluationsRequest.ReadOnly =
    zio.aws.config.model.PutEvaluationsRequest.wrap(buildAwsValue())
}
object PutEvaluationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.PutEvaluationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.PutEvaluationsRequest =
      zio.aws.config.model.PutEvaluationsRequest(
        evaluations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        resultToken,
        testMode.map(value => value)
      )
    def evaluations: Option[List[zio.aws.config.model.Evaluation.ReadOnly]]
    def resultToken: String
    def testMode: Option[Boolean]
    def getEvaluations
        : ZIO[Any, AwsError, List[zio.aws.config.model.Evaluation.ReadOnly]] =
      AwsError.unwrapOptionField("evaluations", evaluations)
    def getResultToken: ZIO[Any, Nothing, String] = ZIO.succeed(resultToken)
    def getTestMode: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("testMode", testMode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.PutEvaluationsRequest
  ) extends zio.aws.config.model.PutEvaluationsRequest.ReadOnly {
    override val evaluations
        : Option[List[zio.aws.config.model.Evaluation.ReadOnly]] = scala
      .Option(impl.evaluations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.config.model.Evaluation.wrap(item)
        }.toList
      )
    override val resultToken: String = impl.resultToken(): String
    override val testMode: Option[Boolean] =
      scala.Option(impl.testMode()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.PutEvaluationsRequest
  ): zio.aws.config.model.PutEvaluationsRequest.ReadOnly = new Wrapper(impl)
}
