package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.config.model.primitives.{AwsRegion, AccountId}
import scala.jdk.CollectionConverters.*
final case class PendingAggregationRequest(
    requesterAccountId: Option[AccountId] = None,
    requesterAwsRegion: Option[AwsRegion] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.PendingAggregationRequest = {
    import PendingAggregationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.PendingAggregationRequest
      .builder()
      .optionallyWith(
        requesterAccountId.map(value =>
          AccountId.unwrap(value): java.lang.String
        )
      )(_.requesterAccountId)
      .optionallyWith(
        requesterAwsRegion.map(value =>
          AwsRegion.unwrap(value): java.lang.String
        )
      )(_.requesterAwsRegion)
      .build()
  }
  def asReadOnly: zio.aws.config.model.PendingAggregationRequest.ReadOnly =
    zio.aws.config.model.PendingAggregationRequest.wrap(buildAwsValue())
}
object PendingAggregationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.PendingAggregationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.PendingAggregationRequest =
      zio.aws.config.model.PendingAggregationRequest(
        requesterAccountId.map(value => value),
        requesterAwsRegion.map(value => value)
      )
    def requesterAccountId: Option[AccountId]
    def requesterAwsRegion: Option[AwsRegion]
    def getRequesterAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("requesterAccountId", requesterAccountId)
    def getRequesterAwsRegion: ZIO[Any, AwsError, AwsRegion] =
      AwsError.unwrapOptionField("requesterAwsRegion", requesterAwsRegion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.PendingAggregationRequest
  ) extends zio.aws.config.model.PendingAggregationRequest.ReadOnly {
    override val requesterAccountId: Option[AccountId] = scala
      .Option(impl.requesterAccountId())
      .map(value => zio.aws.config.model.primitives.AccountId(value))
    override val requesterAwsRegion: Option[AwsRegion] = scala
      .Option(impl.requesterAwsRegion())
      .map(value => zio.aws.config.model.primitives.AwsRegion(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.PendingAggregationRequest
  ): zio.aws.config.model.PendingAggregationRequest.ReadOnly = new Wrapper(impl)
}
