package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.config.model.primitives.{
  PolicyRuntime,
  StringWithCharLimit2048,
  AccountId,
  StringWithCharLimit256,
  StringWithCharLimit128,
  StringWithCharLimit768,
  StringWithCharLimit256Min0
}
import scala.jdk.CollectionConverters.*
final case class OrganizationCustomPolicyRuleMetadataNoPolicy(
    description: Option[StringWithCharLimit256Min0] = None,
    organizationConfigRuleTriggerTypes: Option[
      Iterable[zio.aws.config.model.OrganizationConfigRuleTriggerTypeNoSN]
    ] = None,
    inputParameters: Option[StringWithCharLimit2048] = None,
    maximumExecutionFrequency: Option[
      zio.aws.config.model.MaximumExecutionFrequency
    ] = None,
    resourceTypesScope: Option[Iterable[StringWithCharLimit256]] = None,
    resourceIdScope: Option[StringWithCharLimit768] = None,
    tagKeyScope: Option[StringWithCharLimit128] = None,
    tagValueScope: Option[StringWithCharLimit256] = None,
    policyRuntime: Option[PolicyRuntime] = None,
    debugLogDeliveryAccounts: Option[Iterable[AccountId]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.OrganizationCustomPolicyRuleMetadataNoPolicy = {
    import OrganizationCustomPolicyRuleMetadataNoPolicy.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.OrganizationCustomPolicyRuleMetadataNoPolicy
      .builder()
      .optionallyWith(
        description.map(value =>
          StringWithCharLimit256Min0.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        organizationConfigRuleTriggerTypes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.organizationConfigRuleTriggerTypesWithStrings)
      .optionallyWith(
        inputParameters.map(value =>
          StringWithCharLimit2048.unwrap(value): java.lang.String
        )
      )(_.inputParameters)
      .optionallyWith(maximumExecutionFrequency.map(value => value.unwrap))(
        _.maximumExecutionFrequency
      )
      .optionallyWith(
        resourceTypesScope.map(value =>
          value.map { item =>
            StringWithCharLimit256.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.resourceTypesScope)
      .optionallyWith(
        resourceIdScope.map(value =>
          StringWithCharLimit768.unwrap(value): java.lang.String
        )
      )(_.resourceIdScope)
      .optionallyWith(
        tagKeyScope.map(value =>
          StringWithCharLimit128.unwrap(value): java.lang.String
        )
      )(_.tagKeyScope)
      .optionallyWith(
        tagValueScope.map(value =>
          StringWithCharLimit256.unwrap(value): java.lang.String
        )
      )(_.tagValueScope)
      .optionallyWith(
        policyRuntime.map(value =>
          PolicyRuntime.unwrap(value): java.lang.String
        )
      )(_.policyRuntime)
      .optionallyWith(
        debugLogDeliveryAccounts.map(value =>
          value.map { item =>
            AccountId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.debugLogDeliveryAccounts)
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.OrganizationCustomPolicyRuleMetadataNoPolicy.ReadOnly =
    zio.aws.config.model.OrganizationCustomPolicyRuleMetadataNoPolicy
      .wrap(buildAwsValue())
}
object OrganizationCustomPolicyRuleMetadataNoPolicy {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.OrganizationCustomPolicyRuleMetadataNoPolicy
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.config.model.OrganizationCustomPolicyRuleMetadataNoPolicy =
      zio.aws.config.model.OrganizationCustomPolicyRuleMetadataNoPolicy(
        description.map(value => value),
        organizationConfigRuleTriggerTypes.map(value => value),
        inputParameters.map(value => value),
        maximumExecutionFrequency.map(value => value),
        resourceTypesScope.map(value => value),
        resourceIdScope.map(value => value),
        tagKeyScope.map(value => value),
        tagValueScope.map(value => value),
        policyRuntime.map(value => value),
        debugLogDeliveryAccounts.map(value => value)
      )
    def description: Option[StringWithCharLimit256Min0]
    def organizationConfigRuleTriggerTypes: Option[
      List[zio.aws.config.model.OrganizationConfigRuleTriggerTypeNoSN]
    ]
    def inputParameters: Option[StringWithCharLimit2048]
    def maximumExecutionFrequency
        : Option[zio.aws.config.model.MaximumExecutionFrequency]
    def resourceTypesScope: Option[List[StringWithCharLimit256]]
    def resourceIdScope: Option[StringWithCharLimit768]
    def tagKeyScope: Option[StringWithCharLimit128]
    def tagValueScope: Option[StringWithCharLimit256]
    def policyRuntime: Option[PolicyRuntime]
    def debugLogDeliveryAccounts: Option[List[AccountId]]
    def getDescription: ZIO[Any, AwsError, StringWithCharLimit256Min0] =
      AwsError.unwrapOptionField("description", description)
    def getOrganizationConfigRuleTriggerTypes: ZIO[Any, AwsError, List[
      zio.aws.config.model.OrganizationConfigRuleTriggerTypeNoSN
    ]] = AwsError.unwrapOptionField(
      "organizationConfigRuleTriggerTypes",
      organizationConfigRuleTriggerTypes
    )
    def getInputParameters: ZIO[Any, AwsError, StringWithCharLimit2048] =
      AwsError.unwrapOptionField("inputParameters", inputParameters)
    def getMaximumExecutionFrequency
        : ZIO[Any, AwsError, zio.aws.config.model.MaximumExecutionFrequency] =
      AwsError.unwrapOptionField(
        "maximumExecutionFrequency",
        maximumExecutionFrequency
      )
    def getResourceTypesScope
        : ZIO[Any, AwsError, List[StringWithCharLimit256]] =
      AwsError.unwrapOptionField("resourceTypesScope", resourceTypesScope)
    def getResourceIdScope: ZIO[Any, AwsError, StringWithCharLimit768] =
      AwsError.unwrapOptionField("resourceIdScope", resourceIdScope)
    def getTagKeyScope: ZIO[Any, AwsError, StringWithCharLimit128] =
      AwsError.unwrapOptionField("tagKeyScope", tagKeyScope)
    def getTagValueScope: ZIO[Any, AwsError, StringWithCharLimit256] =
      AwsError.unwrapOptionField("tagValueScope", tagValueScope)
    def getPolicyRuntime: ZIO[Any, AwsError, PolicyRuntime] =
      AwsError.unwrapOptionField("policyRuntime", policyRuntime)
    def getDebugLogDeliveryAccounts: ZIO[Any, AwsError, List[AccountId]] =
      AwsError.unwrapOptionField(
        "debugLogDeliveryAccounts",
        debugLogDeliveryAccounts
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.OrganizationCustomPolicyRuleMetadataNoPolicy
  ) extends zio.aws.config.model.OrganizationCustomPolicyRuleMetadataNoPolicy.ReadOnly {
    override val description: Option[StringWithCharLimit256Min0] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.config.model.primitives.StringWithCharLimit256Min0(value)
      )
    override val organizationConfigRuleTriggerTypes: Option[
      List[zio.aws.config.model.OrganizationConfigRuleTriggerTypeNoSN]
    ] = scala
      .Option(impl.organizationConfigRuleTriggerTypes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.config.model.OrganizationConfigRuleTriggerTypeNoSN.wrap(item)
        }.toList
      )
    override val inputParameters: Option[StringWithCharLimit2048] = scala
      .Option(impl.inputParameters())
      .map(value =>
        zio.aws.config.model.primitives.StringWithCharLimit2048(value)
      )
    override val maximumExecutionFrequency
        : Option[zio.aws.config.model.MaximumExecutionFrequency] = scala
      .Option(impl.maximumExecutionFrequency())
      .map(value => zio.aws.config.model.MaximumExecutionFrequency.wrap(value))
    override val resourceTypesScope: Option[List[StringWithCharLimit256]] =
      scala
        .Option(impl.resourceTypesScope())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.config.model.primitives.StringWithCharLimit256(item)
          }.toList
        )
    override val resourceIdScope: Option[StringWithCharLimit768] = scala
      .Option(impl.resourceIdScope())
      .map(value =>
        zio.aws.config.model.primitives.StringWithCharLimit768(value)
      )
    override val tagKeyScope: Option[StringWithCharLimit128] = scala
      .Option(impl.tagKeyScope())
      .map(value =>
        zio.aws.config.model.primitives.StringWithCharLimit128(value)
      )
    override val tagValueScope: Option[StringWithCharLimit256] = scala
      .Option(impl.tagValueScope())
      .map(value =>
        zio.aws.config.model.primitives.StringWithCharLimit256(value)
      )
    override val policyRuntime: Option[PolicyRuntime] = scala
      .Option(impl.policyRuntime())
      .map(value => zio.aws.config.model.primitives.PolicyRuntime(value))
    override val debugLogDeliveryAccounts: Option[List[AccountId]] = scala
      .Option(impl.debugLogDeliveryAccounts())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.config.model.primitives.AccountId(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.OrganizationCustomPolicyRuleMetadataNoPolicy
  ): zio.aws.config.model.OrganizationCustomPolicyRuleMetadataNoPolicy.ReadOnly =
    new Wrapper(impl)
}
