package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class OrganizationAggregationSource(
    roleArn: String,
    awsRegions: Option[Iterable[String]] = None,
    allAwsRegions: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.OrganizationAggregationSource = {
    import OrganizationAggregationSource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.OrganizationAggregationSource
      .builder()
      .roleArn(roleArn: java.lang.String)
      .optionallyWith(
        awsRegions.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.awsRegions)
      .optionallyWith(allAwsRegions.map(value => value: java.lang.Boolean))(
        _.allAwsRegions
      )
      .build()
  }
  def asReadOnly: zio.aws.config.model.OrganizationAggregationSource.ReadOnly =
    zio.aws.config.model.OrganizationAggregationSource.wrap(buildAwsValue())
}
object OrganizationAggregationSource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.OrganizationAggregationSource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.OrganizationAggregationSource =
      zio.aws.config.model.OrganizationAggregationSource(
        roleArn,
        awsRegions.map(value => value),
        allAwsRegions.map(value => value)
      )
    def roleArn: String
    def awsRegions: Option[List[String]]
    def allAwsRegions: Option[Boolean]
    def getRoleArn: ZIO[Any, Nothing, String] = ZIO.succeed(roleArn)
    def getAwsRegions: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("awsRegions", awsRegions)
    def getAllAwsRegions: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("allAwsRegions", allAwsRegions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.OrganizationAggregationSource
  ) extends zio.aws.config.model.OrganizationAggregationSource.ReadOnly {
    override val roleArn: String = impl.roleArn(): String
    override val awsRegions: Option[List[String]] = scala
      .Option(impl.awsRegions())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val allAwsRegions: Option[Boolean] =
      scala.Option(impl.allAwsRegions()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.OrganizationAggregationSource
  ): zio.aws.config.model.OrganizationAggregationSource.ReadOnly = new Wrapper(
    impl
  )
}
