package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.config.model.primitives.PolicyText
import scala.jdk.CollectionConverters.*
final case class GetOrganizationCustomRulePolicyResponse(
    policyText: Option[PolicyText] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.GetOrganizationCustomRulePolicyResponse = {
    import GetOrganizationCustomRulePolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.GetOrganizationCustomRulePolicyResponse
      .builder()
      .optionallyWith(
        policyText.map(value => PolicyText.unwrap(value): java.lang.String)
      )(_.policyText)
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.GetOrganizationCustomRulePolicyResponse.ReadOnly =
    zio.aws.config.model.GetOrganizationCustomRulePolicyResponse
      .wrap(buildAwsValue())
}
object GetOrganizationCustomRulePolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.GetOrganizationCustomRulePolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.config.model.GetOrganizationCustomRulePolicyResponse =
      zio.aws.config.model
        .GetOrganizationCustomRulePolicyResponse(policyText.map(value => value))
    def policyText: Option[PolicyText]
    def getPolicyText: ZIO[Any, AwsError, PolicyText] =
      AwsError.unwrapOptionField("policyText", policyText)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.GetOrganizationCustomRulePolicyResponse
  ) extends zio.aws.config.model.GetOrganizationCustomRulePolicyResponse.ReadOnly {
    override val policyText: Option[PolicyText] = scala
      .Option(impl.policyText())
      .map(value => zio.aws.config.model.primitives.PolicyText(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.GetOrganizationCustomRulePolicyResponse
  ): zio.aws.config.model.GetOrganizationCustomRulePolicyResponse.ReadOnly =
    new Wrapper(impl)
}
