package zio.aws.config.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.config.model.primitives.{
  CosmosPageLimit,
  OrganizationConfigRuleName
}
import scala.jdk.CollectionConverters.*
final case class GetOrganizationConfigRuleDetailedStatusRequest(
    organizationConfigRuleName: OrganizationConfigRuleName,
    filters: Option[zio.aws.config.model.StatusDetailFilters] = None,
    limit: Option[CosmosPageLimit] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.GetOrganizationConfigRuleDetailedStatusRequest = {
    import GetOrganizationConfigRuleDetailedStatusRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.GetOrganizationConfigRuleDetailedStatusRequest
      .builder()
      .organizationConfigRuleName(
        OrganizationConfigRuleName.unwrap(
          organizationConfigRuleName
        ): java.lang.String
      )
      .optionallyWith(filters.map(value => value.buildAwsValue()))(_.filters)
      .optionallyWith(
        limit.map(value => CosmosPageLimit.unwrap(value): Integer)
      )(_.limit)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.GetOrganizationConfigRuleDetailedStatusRequest.ReadOnly =
    zio.aws.config.model.GetOrganizationConfigRuleDetailedStatusRequest
      .wrap(buildAwsValue())
}
object GetOrganizationConfigRuleDetailedStatusRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.GetOrganizationConfigRuleDetailedStatusRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.config.model.GetOrganizationConfigRuleDetailedStatusRequest =
      zio.aws.config.model.GetOrganizationConfigRuleDetailedStatusRequest(
        organizationConfigRuleName,
        filters.map(value => value.asEditable),
        limit.map(value => value),
        nextToken.map(value => value)
      )
    def organizationConfigRuleName: OrganizationConfigRuleName
    def filters: Option[zio.aws.config.model.StatusDetailFilters.ReadOnly]
    def limit: Option[CosmosPageLimit]
    def nextToken: Option[String]
    def getOrganizationConfigRuleName
        : ZIO[Any, Nothing, OrganizationConfigRuleName] =
      ZIO.succeed(organizationConfigRuleName)
    def getFilters: ZIO[
      Any,
      AwsError,
      zio.aws.config.model.StatusDetailFilters.ReadOnly
    ] = AwsError.unwrapOptionField("filters", filters)
    def getLimit: ZIO[Any, AwsError, CosmosPageLimit] =
      AwsError.unwrapOptionField("limit", limit)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.GetOrganizationConfigRuleDetailedStatusRequest
  ) extends zio.aws.config.model.GetOrganizationConfigRuleDetailedStatusRequest.ReadOnly {
    override val organizationConfigRuleName: OrganizationConfigRuleName =
      zio.aws.config.model.primitives
        .OrganizationConfigRuleName(impl.organizationConfigRuleName())
    override val filters
        : Option[zio.aws.config.model.StatusDetailFilters.ReadOnly] = scala
      .Option(impl.filters())
      .map(value => zio.aws.config.model.StatusDetailFilters.wrap(value))
    override val limit: Option[CosmosPageLimit] = scala
      .Option(impl.limit())
      .map(value => zio.aws.config.model.primitives.CosmosPageLimit(value))
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.GetOrganizationConfigRuleDetailedStatusRequest
  ): zio.aws.config.model.GetOrganizationConfigRuleDetailedStatusRequest.ReadOnly =
    new Wrapper(impl)
}
