package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.config.model.primitives.PolicyText
import scala.jdk.CollectionConverters.*
final case class GetCustomRulePolicyResponse(
    policyText: Option[PolicyText] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.GetCustomRulePolicyResponse = {
    import GetCustomRulePolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.GetCustomRulePolicyResponse
      .builder()
      .optionallyWith(
        policyText.map(value => PolicyText.unwrap(value): java.lang.String)
      )(_.policyText)
      .build()
  }
  def asReadOnly: zio.aws.config.model.GetCustomRulePolicyResponse.ReadOnly =
    zio.aws.config.model.GetCustomRulePolicyResponse.wrap(buildAwsValue())
}
object GetCustomRulePolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.GetCustomRulePolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.GetCustomRulePolicyResponse =
      zio.aws.config.model
        .GetCustomRulePolicyResponse(policyText.map(value => value))
    def policyText: Option[PolicyText]
    def getPolicyText: ZIO[Any, AwsError, PolicyText] =
      AwsError.unwrapOptionField("policyText", policyText)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.GetCustomRulePolicyResponse
  ) extends zio.aws.config.model.GetCustomRulePolicyResponse.ReadOnly {
    override val policyText: Option[PolicyText] = scala
      .Option(impl.policyText())
      .map(value => zio.aws.config.model.primitives.PolicyText(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.GetCustomRulePolicyResponse
  ): zio.aws.config.model.GetCustomRulePolicyResponse.ReadOnly = new Wrapper(
    impl
  )
}
