package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.config.model.primitives.{NextToken, StringWithCharLimit256}
import scala.jdk.CollectionConverters.*
final case class GetAggregateConfigRuleComplianceSummaryResponse(
    groupByKey: Option[StringWithCharLimit256] = None,
    aggregateComplianceCounts: Option[
      Iterable[zio.aws.config.model.AggregateComplianceCount]
    ] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.GetAggregateConfigRuleComplianceSummaryResponse = {
    import GetAggregateConfigRuleComplianceSummaryResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.GetAggregateConfigRuleComplianceSummaryResponse
      .builder()
      .optionallyWith(
        groupByKey.map(value =>
          StringWithCharLimit256.unwrap(value): java.lang.String
        )
      )(_.groupByKey)
      .optionallyWith(
        aggregateComplianceCounts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.aggregateComplianceCounts)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.GetAggregateConfigRuleComplianceSummaryResponse.ReadOnly =
    zio.aws.config.model.GetAggregateConfigRuleComplianceSummaryResponse
      .wrap(buildAwsValue())
}
object GetAggregateConfigRuleComplianceSummaryResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.GetAggregateConfigRuleComplianceSummaryResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.config.model.GetAggregateConfigRuleComplianceSummaryResponse =
      zio.aws.config.model.GetAggregateConfigRuleComplianceSummaryResponse(
        groupByKey.map(value => value),
        aggregateComplianceCounts.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def groupByKey: Option[StringWithCharLimit256]
    def aggregateComplianceCounts
        : Option[List[zio.aws.config.model.AggregateComplianceCount.ReadOnly]]
    def nextToken: Option[NextToken]
    def getGroupByKey: ZIO[Any, AwsError, StringWithCharLimit256] =
      AwsError.unwrapOptionField("groupByKey", groupByKey)
    def getAggregateComplianceCounts: ZIO[Any, AwsError, List[
      zio.aws.config.model.AggregateComplianceCount.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "aggregateComplianceCounts",
      aggregateComplianceCounts
    )
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.GetAggregateConfigRuleComplianceSummaryResponse
  ) extends zio.aws.config.model.GetAggregateConfigRuleComplianceSummaryResponse.ReadOnly {
    override val groupByKey: Option[StringWithCharLimit256] = scala
      .Option(impl.groupByKey())
      .map(value =>
        zio.aws.config.model.primitives.StringWithCharLimit256(value)
      )
    override val aggregateComplianceCounts
        : Option[List[zio.aws.config.model.AggregateComplianceCount.ReadOnly]] =
      scala
        .Option(impl.aggregateComplianceCounts())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.config.model.AggregateComplianceCount.wrap(item)
          }.toList
        )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.config.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.GetAggregateConfigRuleComplianceSummaryResponse
  ): zio.aws.config.model.GetAggregateConfigRuleComplianceSummaryResponse.ReadOnly =
    new Wrapper(impl)
}
