package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.config.model.primitives.{NextToken, RetentionConfigurationName}
import scala.jdk.CollectionConverters.*
final case class DescribeRetentionConfigurationsRequest(
    retentionConfigurationNames: Option[Iterable[RetentionConfigurationName]] =
      None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.DescribeRetentionConfigurationsRequest = {
    import DescribeRetentionConfigurationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.DescribeRetentionConfigurationsRequest
      .builder()
      .optionallyWith(
        retentionConfigurationNames.map(value =>
          value.map { item =>
            RetentionConfigurationName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.retentionConfigurationNames)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.DescribeRetentionConfigurationsRequest.ReadOnly =
    zio.aws.config.model.DescribeRetentionConfigurationsRequest
      .wrap(buildAwsValue())
}
object DescribeRetentionConfigurationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.DescribeRetentionConfigurationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.config.model.DescribeRetentionConfigurationsRequest =
      zio.aws.config.model.DescribeRetentionConfigurationsRequest(
        retentionConfigurationNames.map(value => value),
        nextToken.map(value => value)
      )
    def retentionConfigurationNames: Option[List[RetentionConfigurationName]]
    def nextToken: Option[NextToken]
    def getRetentionConfigurationNames
        : ZIO[Any, AwsError, List[RetentionConfigurationName]] =
      AwsError.unwrapOptionField(
        "retentionConfigurationNames",
        retentionConfigurationNames
      )
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.DescribeRetentionConfigurationsRequest
  ) extends zio.aws.config.model.DescribeRetentionConfigurationsRequest.ReadOnly {
    override val retentionConfigurationNames
        : Option[List[RetentionConfigurationName]] = scala
      .Option(impl.retentionConfigurationNames())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.config.model.primitives.RetentionConfigurationName(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.config.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.DescribeRetentionConfigurationsRequest
  ): zio.aws.config.model.DescribeRetentionConfigurationsRequest.ReadOnly =
    new Wrapper(impl)
}
