package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribePendingAggregationRequestsResponse(
    pendingAggregationRequests: Option[
      Iterable[zio.aws.config.model.PendingAggregationRequest]
    ] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.DescribePendingAggregationRequestsResponse = {
    import DescribePendingAggregationRequestsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.DescribePendingAggregationRequestsResponse
      .builder()
      .optionallyWith(
        pendingAggregationRequests.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.pendingAggregationRequests)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.DescribePendingAggregationRequestsResponse.ReadOnly =
    zio.aws.config.model.DescribePendingAggregationRequestsResponse
      .wrap(buildAwsValue())
}
object DescribePendingAggregationRequestsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.DescribePendingAggregationRequestsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.config.model.DescribePendingAggregationRequestsResponse =
      zio.aws.config.model.DescribePendingAggregationRequestsResponse(
        pendingAggregationRequests.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def pendingAggregationRequests
        : Option[List[zio.aws.config.model.PendingAggregationRequest.ReadOnly]]
    def nextToken: Option[String]
    def getPendingAggregationRequests: ZIO[Any, AwsError, List[
      zio.aws.config.model.PendingAggregationRequest.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "pendingAggregationRequests",
      pendingAggregationRequests
    )
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.DescribePendingAggregationRequestsResponse
  ) extends zio.aws.config.model.DescribePendingAggregationRequestsResponse.ReadOnly {
    override val pendingAggregationRequests: Option[
      List[zio.aws.config.model.PendingAggregationRequest.ReadOnly]
    ] = scala
      .Option(impl.pendingAggregationRequests())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.config.model.PendingAggregationRequest.wrap(item)
        }.toList
      )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.DescribePendingAggregationRequestsResponse
  ): zio.aws.config.model.DescribePendingAggregationRequestsResponse.ReadOnly =
    new Wrapper(impl)
}
