package zio.aws.config.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.config.model.primitives.{CosmosPageLimit, StringWithCharLimit64}
import scala.jdk.CollectionConverters.*
final case class DescribeOrganizationConfigRuleStatusesRequest(
    organizationConfigRuleNames: Option[Iterable[StringWithCharLimit64]] = None,
    limit: Option[CosmosPageLimit] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.DescribeOrganizationConfigRuleStatusesRequest = {
    import DescribeOrganizationConfigRuleStatusesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.DescribeOrganizationConfigRuleStatusesRequest
      .builder()
      .optionallyWith(
        organizationConfigRuleNames.map(value =>
          value.map { item =>
            StringWithCharLimit64.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.organizationConfigRuleNames)
      .optionallyWith(
        limit.map(value => CosmosPageLimit.unwrap(value): Integer)
      )(_.limit)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.DescribeOrganizationConfigRuleStatusesRequest.ReadOnly =
    zio.aws.config.model.DescribeOrganizationConfigRuleStatusesRequest
      .wrap(buildAwsValue())
}
object DescribeOrganizationConfigRuleStatusesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.DescribeOrganizationConfigRuleStatusesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.config.model.DescribeOrganizationConfigRuleStatusesRequest =
      zio.aws.config.model.DescribeOrganizationConfigRuleStatusesRequest(
        organizationConfigRuleNames.map(value => value),
        limit.map(value => value),
        nextToken.map(value => value)
      )
    def organizationConfigRuleNames: Option[List[StringWithCharLimit64]]
    def limit: Option[CosmosPageLimit]
    def nextToken: Option[String]
    def getOrganizationConfigRuleNames
        : ZIO[Any, AwsError, List[StringWithCharLimit64]] =
      AwsError.unwrapOptionField(
        "organizationConfigRuleNames",
        organizationConfigRuleNames
      )
    def getLimit: ZIO[Any, AwsError, CosmosPageLimit] =
      AwsError.unwrapOptionField("limit", limit)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.DescribeOrganizationConfigRuleStatusesRequest
  ) extends zio.aws.config.model.DescribeOrganizationConfigRuleStatusesRequest.ReadOnly {
    override val organizationConfigRuleNames
        : Option[List[StringWithCharLimit64]] = scala
      .Option(impl.organizationConfigRuleNames())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.config.model.primitives.StringWithCharLimit64(item)
        }.toList
      )
    override val limit: Option[CosmosPageLimit] = scala
      .Option(impl.limit())
      .map(value => zio.aws.config.model.primitives.CosmosPageLimit(value))
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.DescribeOrganizationConfigRuleStatusesRequest
  ): zio.aws.config.model.DescribeOrganizationConfigRuleStatusesRequest.ReadOnly =
    new Wrapper(impl)
}
