package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeAggregationAuthorizationsResponse(
    aggregationAuthorizations: Option[
      Iterable[zio.aws.config.model.AggregationAuthorization]
    ] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.DescribeAggregationAuthorizationsResponse = {
    import DescribeAggregationAuthorizationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.DescribeAggregationAuthorizationsResponse
      .builder()
      .optionallyWith(
        aggregationAuthorizations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.aggregationAuthorizations)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.DescribeAggregationAuthorizationsResponse.ReadOnly =
    zio.aws.config.model.DescribeAggregationAuthorizationsResponse
      .wrap(buildAwsValue())
}
object DescribeAggregationAuthorizationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.DescribeAggregationAuthorizationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.config.model.DescribeAggregationAuthorizationsResponse =
      zio.aws.config.model.DescribeAggregationAuthorizationsResponse(
        aggregationAuthorizations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def aggregationAuthorizations
        : Option[List[zio.aws.config.model.AggregationAuthorization.ReadOnly]]
    def nextToken: Option[String]
    def getAggregationAuthorizations: ZIO[Any, AwsError, List[
      zio.aws.config.model.AggregationAuthorization.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "aggregationAuthorizations",
      aggregationAuthorizations
    )
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.DescribeAggregationAuthorizationsResponse
  ) extends zio.aws.config.model.DescribeAggregationAuthorizationsResponse.ReadOnly {
    override val aggregationAuthorizations
        : Option[List[zio.aws.config.model.AggregationAuthorization.ReadOnly]] =
      scala
        .Option(impl.aggregationAuthorizations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.config.model.AggregationAuthorization.wrap(item)
          }.toList
        )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.DescribeAggregationAuthorizationsResponse
  ): zio.aws.config.model.DescribeAggregationAuthorizationsResponse.ReadOnly =
    new Wrapper(impl)
}
