package zio.aws.config.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.config.model.primitives.ConformancePackName
import scala.jdk.CollectionConverters.*
final case class DeleteConformancePackRequest(
    conformancePackName: ConformancePackName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.DeleteConformancePackRequest = {
    import DeleteConformancePackRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.DeleteConformancePackRequest
      .builder()
      .conformancePackName(
        ConformancePackName.unwrap(conformancePackName): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.config.model.DeleteConformancePackRequest.ReadOnly =
    zio.aws.config.model.DeleteConformancePackRequest.wrap(buildAwsValue())
}
object DeleteConformancePackRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.DeleteConformancePackRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.DeleteConformancePackRequest =
      zio.aws.config.model.DeleteConformancePackRequest(conformancePackName)
    def conformancePackName: ConformancePackName
    def getConformancePackName: ZIO[Any, Nothing, ConformancePackName] =
      ZIO.succeed(conformancePackName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.DeleteConformancePackRequest
  ) extends zio.aws.config.model.DeleteConformancePackRequest.ReadOnly {
    override val conformancePackName: ConformancePackName =
      zio.aws.config.model.primitives
        .ConformancePackName(impl.conformancePackName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.DeleteConformancePackRequest
  ): zio.aws.config.model.DeleteConformancePackRequest.ReadOnly = new Wrapper(
    impl
  )
}
