package zio.aws.config.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.config.model.primitives.ConfigRuleName
import scala.jdk.CollectionConverters.*
final case class DeleteConfigRuleRequest(configRuleName: ConfigRuleName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.DeleteConfigRuleRequest = {
    import DeleteConfigRuleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.DeleteConfigRuleRequest
      .builder()
      .configRuleName(ConfigRuleName.unwrap(configRuleName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.config.model.DeleteConfigRuleRequest.ReadOnly =
    zio.aws.config.model.DeleteConfigRuleRequest.wrap(buildAwsValue())
}
object DeleteConfigRuleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.DeleteConfigRuleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.DeleteConfigRuleRequest =
      zio.aws.config.model.DeleteConfigRuleRequest(configRuleName)
    def configRuleName: ConfigRuleName
    def getConfigRuleName: ZIO[Any, Nothing, ConfigRuleName] =
      ZIO.succeed(configRuleName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.DeleteConfigRuleRequest
  ) extends zio.aws.config.model.DeleteConfigRuleRequest.ReadOnly {
    override val configRuleName: ConfigRuleName =
      zio.aws.config.model.primitives.ConfigRuleName(impl.configRuleName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.DeleteConfigRuleRequest
  ): zio.aws.config.model.DeleteConfigRuleRequest.ReadOnly = new Wrapper(impl)
}
