package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.config.model.primitives.{PolicyText, PolicyRuntime}
import scala.jdk.CollectionConverters.*
final case class CustomPolicyDetails(
    policyRuntime: PolicyRuntime,
    policyText: PolicyText,
    enableDebugLogDelivery: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.CustomPolicyDetails = {
    import CustomPolicyDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.CustomPolicyDetails
      .builder()
      .policyRuntime(PolicyRuntime.unwrap(policyRuntime): java.lang.String)
      .policyText(PolicyText.unwrap(policyText): java.lang.String)
      .optionallyWith(
        enableDebugLogDelivery.map(value => value: java.lang.Boolean)
      )(_.enableDebugLogDelivery)
      .build()
  }
  def asReadOnly: zio.aws.config.model.CustomPolicyDetails.ReadOnly =
    zio.aws.config.model.CustomPolicyDetails.wrap(buildAwsValue())
}
object CustomPolicyDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.CustomPolicyDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.CustomPolicyDetails =
      zio.aws.config.model.CustomPolicyDetails(
        policyRuntime,
        policyText,
        enableDebugLogDelivery.map(value => value)
      )
    def policyRuntime: PolicyRuntime
    def policyText: PolicyText
    def enableDebugLogDelivery: Option[Boolean]
    def getPolicyRuntime: ZIO[Any, Nothing, PolicyRuntime] =
      ZIO.succeed(policyRuntime)
    def getPolicyText: ZIO[Any, Nothing, PolicyText] = ZIO.succeed(policyText)
    def getEnableDebugLogDelivery: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("enableDebugLogDelivery", enableDebugLogDelivery)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.CustomPolicyDetails
  ) extends zio.aws.config.model.CustomPolicyDetails.ReadOnly {
    override val policyRuntime: PolicyRuntime =
      zio.aws.config.model.primitives.PolicyRuntime(impl.policyRuntime())
    override val policyText: PolicyText =
      zio.aws.config.model.primitives.PolicyText(impl.policyText())
    override val enableDebugLogDelivery: Option[Boolean] =
      scala.Option(impl.enableDebugLogDelivery()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.CustomPolicyDetails
  ): zio.aws.config.model.CustomPolicyDetails.ReadOnly = new Wrapper(impl)
}
