package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.config.model.primitives.{StringWithCharLimit128, ConfigRuleName}
import scala.jdk.CollectionConverters.*
final case class ConformancePackRuleCompliance(
    configRuleName: Option[ConfigRuleName] = None,
    complianceType: Option[zio.aws.config.model.ConformancePackComplianceType] =
      None,
    controls: Option[Iterable[StringWithCharLimit128]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.ConformancePackRuleCompliance = {
    import ConformancePackRuleCompliance.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.ConformancePackRuleCompliance
      .builder()
      .optionallyWith(
        configRuleName.map(value =>
          ConfigRuleName.unwrap(value): java.lang.String
        )
      )(_.configRuleName)
      .optionallyWith(complianceType.map(value => value.unwrap))(
        _.complianceType
      )
      .optionallyWith(
        controls.map(value =>
          value.map { item =>
            StringWithCharLimit128.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.controls)
      .build()
  }
  def asReadOnly: zio.aws.config.model.ConformancePackRuleCompliance.ReadOnly =
    zio.aws.config.model.ConformancePackRuleCompliance.wrap(buildAwsValue())
}
object ConformancePackRuleCompliance {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.ConformancePackRuleCompliance
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.ConformancePackRuleCompliance =
      zio.aws.config.model.ConformancePackRuleCompliance(
        configRuleName.map(value => value),
        complianceType.map(value => value),
        controls.map(value => value)
      )
    def configRuleName: Option[ConfigRuleName]
    def complianceType
        : Option[zio.aws.config.model.ConformancePackComplianceType]
    def controls: Option[List[StringWithCharLimit128]]
    def getConfigRuleName: ZIO[Any, AwsError, ConfigRuleName] =
      AwsError.unwrapOptionField("configRuleName", configRuleName)
    def getComplianceType: ZIO[
      Any,
      AwsError,
      zio.aws.config.model.ConformancePackComplianceType
    ] = AwsError.unwrapOptionField("complianceType", complianceType)
    def getControls: ZIO[Any, AwsError, List[StringWithCharLimit128]] =
      AwsError.unwrapOptionField("controls", controls)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.ConformancePackRuleCompliance
  ) extends zio.aws.config.model.ConformancePackRuleCompliance.ReadOnly {
    override val configRuleName: Option[ConfigRuleName] = scala
      .Option(impl.configRuleName())
      .map(value => zio.aws.config.model.primitives.ConfigRuleName(value))
    override val complianceType
        : Option[zio.aws.config.model.ConformancePackComplianceType] = scala
      .Option(impl.complianceType())
      .map(value =>
        zio.aws.config.model.ConformancePackComplianceType.wrap(value)
      )
    override val controls: Option[List[StringWithCharLimit128]] = scala
      .Option(impl.controls())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.config.model.primitives.StringWithCharLimit128(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.ConformancePackRuleCompliance
  ): zio.aws.config.model.ConformancePackRuleCompliance.ReadOnly = new Wrapper(
    impl
  )
}
