package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.config.model.primitives.StringWithCharLimit256
import scala.jdk.CollectionConverters.*
final case class AggregateConformancePackComplianceSummary(
    complianceSummary: Option[
      zio.aws.config.model.AggregateConformancePackComplianceCount
    ] = None,
    groupName: Option[StringWithCharLimit256] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.AggregateConformancePackComplianceSummary = {
    import AggregateConformancePackComplianceSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.AggregateConformancePackComplianceSummary
      .builder()
      .optionallyWith(complianceSummary.map(value => value.buildAwsValue()))(
        _.complianceSummary
      )
      .optionallyWith(
        groupName.map(value =>
          StringWithCharLimit256.unwrap(value): java.lang.String
        )
      )(_.groupName)
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.AggregateConformancePackComplianceSummary.ReadOnly =
    zio.aws.config.model.AggregateConformancePackComplianceSummary
      .wrap(buildAwsValue())
}
object AggregateConformancePackComplianceSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.AggregateConformancePackComplianceSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.config.model.AggregateConformancePackComplianceSummary =
      zio.aws.config.model.AggregateConformancePackComplianceSummary(
        complianceSummary.map(value => value.asEditable),
        groupName.map(value => value)
      )
    def complianceSummary: Option[
      zio.aws.config.model.AggregateConformancePackComplianceCount.ReadOnly
    ]
    def groupName: Option[StringWithCharLimit256]
    def getComplianceSummary: ZIO[
      Any,
      AwsError,
      zio.aws.config.model.AggregateConformancePackComplianceCount.ReadOnly
    ] = AwsError.unwrapOptionField("complianceSummary", complianceSummary)
    def getGroupName: ZIO[Any, AwsError, StringWithCharLimit256] =
      AwsError.unwrapOptionField("groupName", groupName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.AggregateConformancePackComplianceSummary
  ) extends zio.aws.config.model.AggregateConformancePackComplianceSummary.ReadOnly {
    override val complianceSummary: Option[
      zio.aws.config.model.AggregateConformancePackComplianceCount.ReadOnly
    ] = scala
      .Option(impl.complianceSummary())
      .map(value =>
        zio.aws.config.model.AggregateConformancePackComplianceCount.wrap(value)
      )
    override val groupName: Option[StringWithCharLimit256] = scala
      .Option(impl.groupName())
      .map(value =>
        zio.aws.config.model.primitives.StringWithCharLimit256(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.AggregateConformancePackComplianceSummary
  ): zio.aws.config.model.AggregateConformancePackComplianceSummary.ReadOnly =
    new Wrapper(impl)
}
