package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.config.model.primitives.{
  Value,
  ResourceTypeString,
  Configuration,
  Name,
  ResourceId,
  SchemaVersionId,
  ResourceName
}
import scala.jdk.CollectionConverters.*
final case class PutResourceConfigRequest(
    resourceType: ResourceTypeString,
    schemaVersionId: SchemaVersionId,
    resourceId: ResourceId,
    resourceName: Option[ResourceName] = None,
    configuration: Configuration,
    tags: Option[Map[Name, Value]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.PutResourceConfigRequest = {
    import PutResourceConfigRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.PutResourceConfigRequest
      .builder()
      .resourceType(ResourceTypeString.unwrap(resourceType): java.lang.String)
      .schemaVersionId(
        SchemaVersionId.unwrap(schemaVersionId): java.lang.String
      )
      .resourceId(ResourceId.unwrap(resourceId): java.lang.String)
      .optionallyWith(
        resourceName.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.resourceName)
      .configuration(Configuration.unwrap(configuration): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (Name.unwrap(key): java.lang.String) -> (Value
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.config.model.PutResourceConfigRequest.ReadOnly =
    zio.aws.config.model.PutResourceConfigRequest.wrap(buildAwsValue())
}
object PutResourceConfigRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.PutResourceConfigRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.PutResourceConfigRequest =
      zio.aws.config.model.PutResourceConfigRequest(
        resourceType,
        schemaVersionId,
        resourceId,
        resourceName.map(value => value),
        configuration,
        tags.map(value => value)
      )
    def resourceType: ResourceTypeString
    def schemaVersionId: SchemaVersionId
    def resourceId: ResourceId
    def resourceName: Option[ResourceName]
    def configuration: Configuration
    def tags: Option[Map[Name, Value]]
    def getResourceType: ZIO[Any, Nothing, ResourceTypeString] =
      ZIO.succeed(resourceType)
    def getSchemaVersionId: ZIO[Any, Nothing, SchemaVersionId] =
      ZIO.succeed(schemaVersionId)
    def getResourceId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(resourceId)
    def getResourceName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("resourceName", resourceName)
    def getConfiguration: ZIO[Any, Nothing, Configuration] =
      ZIO.succeed(configuration)
    def getTags: ZIO[Any, AwsError, Map[Name, Value]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.PutResourceConfigRequest
  ) extends zio.aws.config.model.PutResourceConfigRequest.ReadOnly {
    override val resourceType: ResourceTypeString =
      zio.aws.config.model.primitives.ResourceTypeString(impl.resourceType())
    override val schemaVersionId: SchemaVersionId =
      zio.aws.config.model.primitives.SchemaVersionId(impl.schemaVersionId())
    override val resourceId: ResourceId =
      zio.aws.config.model.primitives.ResourceId(impl.resourceId())
    override val resourceName: Option[ResourceName] = scala
      .Option(impl.resourceName())
      .map(value => zio.aws.config.model.primitives.ResourceName(value))
    override val configuration: Configuration =
      zio.aws.config.model.primitives.Configuration(impl.configuration())
    override val tags: Option[Map[Name, Value]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.config.model.primitives
              .Name(key) -> zio.aws.config.model.primitives.Value(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.PutResourceConfigRequest
  ): zio.aws.config.model.PutResourceConfigRequest.ReadOnly = new Wrapper(impl)
}
