package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.config.model.primitives.{Date, StringWithCharLimit256, AccountId}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class OrganizationConformancePackDetailedStatus(
    accountId: AccountId,
    conformancePackName: StringWithCharLimit256,
    status: zio.aws.config.model.OrganizationResourceDetailedStatus,
    errorCode: Option[String] = None,
    errorMessage: Option[String] = None,
    lastUpdateTime: Option[Date] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.OrganizationConformancePackDetailedStatus = {
    import OrganizationConformancePackDetailedStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.OrganizationConformancePackDetailedStatus
      .builder()
      .accountId(AccountId.unwrap(accountId): java.lang.String)
      .conformancePackName(
        StringWithCharLimit256.unwrap(conformancePackName): java.lang.String
      )
      .status(status.unwrap)
      .optionallyWith(errorCode.map(value => value: java.lang.String))(
        _.errorCode
      )
      .optionallyWith(errorMessage.map(value => value: java.lang.String))(
        _.errorMessage
      )
      .optionallyWith(lastUpdateTime.map(value => Date.unwrap(value): Instant))(
        _.lastUpdateTime
      )
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.OrganizationConformancePackDetailedStatus.ReadOnly =
    zio.aws.config.model.OrganizationConformancePackDetailedStatus
      .wrap(buildAwsValue())
}
object OrganizationConformancePackDetailedStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.OrganizationConformancePackDetailedStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.config.model.OrganizationConformancePackDetailedStatus =
      zio.aws.config.model.OrganizationConformancePackDetailedStatus(
        accountId,
        conformancePackName,
        status,
        errorCode.map(value => value),
        errorMessage.map(value => value),
        lastUpdateTime.map(value => value)
      )
    def accountId: AccountId
    def conformancePackName: StringWithCharLimit256
    def status: zio.aws.config.model.OrganizationResourceDetailedStatus
    def errorCode: Option[String]
    def errorMessage: Option[String]
    def lastUpdateTime: Option[Date]
    def getAccountId: ZIO[Any, Nothing, AccountId] = ZIO.succeed(accountId)
    def getConformancePackName: ZIO[Any, Nothing, StringWithCharLimit256] =
      ZIO.succeed(conformancePackName)
    def getStatus: ZIO[
      Any,
      Nothing,
      zio.aws.config.model.OrganizationResourceDetailedStatus
    ] = ZIO.succeed(status)
    def getErrorCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("errorCode", errorCode)
    def getErrorMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
    def getLastUpdateTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("lastUpdateTime", lastUpdateTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.OrganizationConformancePackDetailedStatus
  ) extends zio.aws.config.model.OrganizationConformancePackDetailedStatus.ReadOnly {
    override val accountId: AccountId =
      zio.aws.config.model.primitives.AccountId(impl.accountId())
    override val conformancePackName: StringWithCharLimit256 =
      zio.aws.config.model.primitives
        .StringWithCharLimit256(impl.conformancePackName())
    override val status
        : zio.aws.config.model.OrganizationResourceDetailedStatus =
      zio.aws.config.model.OrganizationResourceDetailedStatus
        .wrap(impl.status())
    override val errorCode: Option[String] =
      scala.Option(impl.errorCode()).map(value => value: String)
    override val errorMessage: Option[String] =
      scala.Option(impl.errorMessage()).map(value => value: String)
    override val lastUpdateTime: Option[Date] = scala
      .Option(impl.lastUpdateTime())
      .map(value => zio.aws.config.model.primitives.Date(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.OrganizationConformancePackDetailedStatus
  ): zio.aws.config.model.OrganizationConformancePackDetailedStatus.ReadOnly =
    new Wrapper(impl)
}
