package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.config.model.primitives.{Date, OrganizationConfigRuleName}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class OrganizationConfigRuleStatus(
    organizationConfigRuleName: OrganizationConfigRuleName,
    organizationRuleStatus: zio.aws.config.model.OrganizationRuleStatus,
    errorCode: Option[String] = None,
    errorMessage: Option[String] = None,
    lastUpdateTime: Option[Date] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.OrganizationConfigRuleStatus = {
    import OrganizationConfigRuleStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.OrganizationConfigRuleStatus
      .builder()
      .organizationConfigRuleName(
        OrganizationConfigRuleName.unwrap(
          organizationConfigRuleName
        ): java.lang.String
      )
      .organizationRuleStatus(organizationRuleStatus.unwrap)
      .optionallyWith(errorCode.map(value => value: java.lang.String))(
        _.errorCode
      )
      .optionallyWith(errorMessage.map(value => value: java.lang.String))(
        _.errorMessage
      )
      .optionallyWith(lastUpdateTime.map(value => Date.unwrap(value): Instant))(
        _.lastUpdateTime
      )
      .build()
  }
  def asReadOnly: zio.aws.config.model.OrganizationConfigRuleStatus.ReadOnly =
    zio.aws.config.model.OrganizationConfigRuleStatus.wrap(buildAwsValue())
}
object OrganizationConfigRuleStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.OrganizationConfigRuleStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.OrganizationConfigRuleStatus =
      zio.aws.config.model.OrganizationConfigRuleStatus(
        organizationConfigRuleName,
        organizationRuleStatus,
        errorCode.map(value => value),
        errorMessage.map(value => value),
        lastUpdateTime.map(value => value)
      )
    def organizationConfigRuleName: OrganizationConfigRuleName
    def organizationRuleStatus: zio.aws.config.model.OrganizationRuleStatus
    def errorCode: Option[String]
    def errorMessage: Option[String]
    def lastUpdateTime: Option[Date]
    def getOrganizationConfigRuleName
        : ZIO[Any, Nothing, OrganizationConfigRuleName] =
      ZIO.succeed(organizationConfigRuleName)
    def getOrganizationRuleStatus
        : ZIO[Any, Nothing, zio.aws.config.model.OrganizationRuleStatus] =
      ZIO.succeed(organizationRuleStatus)
    def getErrorCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("errorCode", errorCode)
    def getErrorMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
    def getLastUpdateTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("lastUpdateTime", lastUpdateTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.OrganizationConfigRuleStatus
  ) extends zio.aws.config.model.OrganizationConfigRuleStatus.ReadOnly {
    override val organizationConfigRuleName: OrganizationConfigRuleName =
      zio.aws.config.model.primitives
        .OrganizationConfigRuleName(impl.organizationConfigRuleName())
    override val organizationRuleStatus
        : zio.aws.config.model.OrganizationRuleStatus =
      zio.aws.config.model.OrganizationRuleStatus
        .wrap(impl.organizationRuleStatus())
    override val errorCode: Option[String] =
      scala.Option(impl.errorCode()).map(value => value: String)
    override val errorMessage: Option[String] =
      scala.Option(impl.errorMessage()).map(value => value: String)
    override val lastUpdateTime: Option[Date] = scala
      .Option(impl.lastUpdateTime())
      .map(value => zio.aws.config.model.primitives.Date(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.OrganizationConfigRuleStatus
  ): zio.aws.config.model.OrganizationConfigRuleStatus.ReadOnly = new Wrapper(
    impl
  )
}
