package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.config.model.primitives.NextToken
import scala.jdk.CollectionConverters.*
final case class DescribeRetentionConfigurationsResponse(
    retentionConfigurations: Option[
      Iterable[zio.aws.config.model.RetentionConfiguration]
    ] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.DescribeRetentionConfigurationsResponse = {
    import DescribeRetentionConfigurationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.DescribeRetentionConfigurationsResponse
      .builder()
      .optionallyWith(
        retentionConfigurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.retentionConfigurations)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.DescribeRetentionConfigurationsResponse.ReadOnly =
    zio.aws.config.model.DescribeRetentionConfigurationsResponse
      .wrap(buildAwsValue())
}
object DescribeRetentionConfigurationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.DescribeRetentionConfigurationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.config.model.DescribeRetentionConfigurationsResponse =
      zio.aws.config.model.DescribeRetentionConfigurationsResponse(
        retentionConfigurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def retentionConfigurations
        : Option[List[zio.aws.config.model.RetentionConfiguration.ReadOnly]]
    def nextToken: Option[NextToken]
    def getRetentionConfigurations: ZIO[Any, AwsError, List[
      zio.aws.config.model.RetentionConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "retentionConfigurations",
      retentionConfigurations
    )
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.DescribeRetentionConfigurationsResponse
  ) extends zio.aws.config.model.DescribeRetentionConfigurationsResponse.ReadOnly {
    override val retentionConfigurations
        : Option[List[zio.aws.config.model.RetentionConfiguration.ReadOnly]] =
      scala
        .Option(impl.retentionConfigurations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.config.model.RetentionConfiguration.wrap(item)
          }.toList
        )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.config.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.DescribeRetentionConfigurationsResponse
  ): zio.aws.config.model.DescribeRetentionConfigurationsResponse.ReadOnly =
    new Wrapper(impl)
}
