package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.config.model.primitives.{NextToken, ConformancePackName}
import scala.jdk.CollectionConverters.*
final case class DescribeConformancePackComplianceResponse(
    conformancePackName: ConformancePackName,
    conformancePackRuleComplianceList: Iterable[
      zio.aws.config.model.ConformancePackRuleCompliance
    ],
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.DescribeConformancePackComplianceResponse = {
    import DescribeConformancePackComplianceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.DescribeConformancePackComplianceResponse
      .builder()
      .conformancePackName(
        ConformancePackName.unwrap(conformancePackName): java.lang.String
      )
      .conformancePackRuleComplianceList(conformancePackRuleComplianceList.map {
        item =>
          item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.DescribeConformancePackComplianceResponse.ReadOnly =
    zio.aws.config.model.DescribeConformancePackComplianceResponse
      .wrap(buildAwsValue())
}
object DescribeConformancePackComplianceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.DescribeConformancePackComplianceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.config.model.DescribeConformancePackComplianceResponse =
      zio.aws.config.model.DescribeConformancePackComplianceResponse(
        conformancePackName,
        conformancePackRuleComplianceList.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def conformancePackName: ConformancePackName
    def conformancePackRuleComplianceList
        : List[zio.aws.config.model.ConformancePackRuleCompliance.ReadOnly]
    def nextToken: Option[NextToken]
    def getConformancePackName: ZIO[Any, Nothing, ConformancePackName] =
      ZIO.succeed(conformancePackName)
    def getConformancePackRuleComplianceList: ZIO[Any, Nothing, List[
      zio.aws.config.model.ConformancePackRuleCompliance.ReadOnly
    ]] = ZIO.succeed(conformancePackRuleComplianceList)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.DescribeConformancePackComplianceResponse
  ) extends zio.aws.config.model.DescribeConformancePackComplianceResponse.ReadOnly {
    override val conformancePackName: ConformancePackName =
      zio.aws.config.model.primitives
        .ConformancePackName(impl.conformancePackName())
    override val conformancePackRuleComplianceList
        : List[zio.aws.config.model.ConformancePackRuleCompliance.ReadOnly] =
      impl
        .conformancePackRuleComplianceList()
        .asScala
        .map { item =>
          zio.aws.config.model.ConformancePackRuleCompliance.wrap(item)
        }
        .toList
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.config.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.DescribeConformancePackComplianceResponse
  ): zio.aws.config.model.DescribeConformancePackComplianceResponse.ReadOnly =
    new Wrapper(impl)
}
