package zio.aws.config.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.config.model.primitives.{
  NextToken,
  DescribeConformancePackComplianceLimit,
  ConformancePackName
}
import scala.jdk.CollectionConverters.*
final case class DescribeConformancePackComplianceRequest(
    conformancePackName: ConformancePackName,
    filters: Option[zio.aws.config.model.ConformancePackComplianceFilters] =
      None,
    limit: Option[DescribeConformancePackComplianceLimit] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.DescribeConformancePackComplianceRequest = {
    import DescribeConformancePackComplianceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.DescribeConformancePackComplianceRequest
      .builder()
      .conformancePackName(
        ConformancePackName.unwrap(conformancePackName): java.lang.String
      )
      .optionallyWith(filters.map(value => value.buildAwsValue()))(_.filters)
      .optionallyWith(
        limit.map(value =>
          DescribeConformancePackComplianceLimit.unwrap(value): Integer
        )
      )(_.limit)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.DescribeConformancePackComplianceRequest.ReadOnly =
    zio.aws.config.model.DescribeConformancePackComplianceRequest
      .wrap(buildAwsValue())
}
object DescribeConformancePackComplianceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.DescribeConformancePackComplianceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.config.model.DescribeConformancePackComplianceRequest =
      zio.aws.config.model.DescribeConformancePackComplianceRequest(
        conformancePackName,
        filters.map(value => value.asEditable),
        limit.map(value => value),
        nextToken.map(value => value)
      )
    def conformancePackName: ConformancePackName
    def filters
        : Option[zio.aws.config.model.ConformancePackComplianceFilters.ReadOnly]
    def limit: Option[DescribeConformancePackComplianceLimit]
    def nextToken: Option[NextToken]
    def getConformancePackName: ZIO[Any, Nothing, ConformancePackName] =
      ZIO.succeed(conformancePackName)
    def getFilters: ZIO[
      Any,
      AwsError,
      zio.aws.config.model.ConformancePackComplianceFilters.ReadOnly
    ] = AwsError.unwrapOptionField("filters", filters)
    def getLimit: ZIO[Any, AwsError, DescribeConformancePackComplianceLimit] =
      AwsError.unwrapOptionField("limit", limit)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.DescribeConformancePackComplianceRequest
  ) extends zio.aws.config.model.DescribeConformancePackComplianceRequest.ReadOnly {
    override val conformancePackName: ConformancePackName =
      zio.aws.config.model.primitives
        .ConformancePackName(impl.conformancePackName())
    override val filters: Option[
      zio.aws.config.model.ConformancePackComplianceFilters.ReadOnly
    ] = scala
      .Option(impl.filters())
      .map(value =>
        zio.aws.config.model.ConformancePackComplianceFilters.wrap(value)
      )
    override val limit: Option[DescribeConformancePackComplianceLimit] = scala
      .Option(impl.limit())
      .map(value =>
        zio.aws.config.model.primitives
          .DescribeConformancePackComplianceLimit(value)
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.config.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.DescribeConformancePackComplianceRequest
  ): zio.aws.config.model.DescribeConformancePackComplianceRequest.ReadOnly =
    new Wrapper(impl)
}
