package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.config.model.primitives.ConfigRuleName
import scala.jdk.CollectionConverters.*
final case class DescribeConfigRulesRequest(
    configRuleNames: Option[Iterable[ConfigRuleName]] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.DescribeConfigRulesRequest = {
    import DescribeConfigRulesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.DescribeConfigRulesRequest
      .builder()
      .optionallyWith(
        configRuleNames.map(value =>
          value.map { item =>
            ConfigRuleName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.configRuleNames)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.config.model.DescribeConfigRulesRequest.ReadOnly =
    zio.aws.config.model.DescribeConfigRulesRequest.wrap(buildAwsValue())
}
object DescribeConfigRulesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.DescribeConfigRulesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.DescribeConfigRulesRequest =
      zio.aws.config.model.DescribeConfigRulesRequest(
        configRuleNames.map(value => value),
        nextToken.map(value => value)
      )
    def configRuleNames: Option[List[ConfigRuleName]]
    def nextToken: Option[String]
    def getConfigRuleNames: ZIO[Any, AwsError, List[ConfigRuleName]] =
      AwsError.unwrapOptionField("configRuleNames", configRuleNames)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.DescribeConfigRulesRequest
  ) extends zio.aws.config.model.DescribeConfigRulesRequest.ReadOnly {
    override val configRuleNames: Option[List[ConfigRuleName]] = scala
      .Option(impl.configRuleNames())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.config.model.primitives.ConfigRuleName(item)
        }.toList
      )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.DescribeConfigRulesRequest
  ): zio.aws.config.model.DescribeConfigRulesRequest.ReadOnly = new Wrapper(
    impl
  )
}
