package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.config.model.primitives.NextToken
import scala.jdk.CollectionConverters.*
final case class DescribeComplianceByResourceResponse(
    complianceByResources: Option[
      Iterable[zio.aws.config.model.ComplianceByResource]
    ] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.DescribeComplianceByResourceResponse = {
    import DescribeComplianceByResourceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.DescribeComplianceByResourceResponse
      .builder()
      .optionallyWith(
        complianceByResources.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.complianceByResources)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.DescribeComplianceByResourceResponse.ReadOnly =
    zio.aws.config.model.DescribeComplianceByResourceResponse
      .wrap(buildAwsValue())
}
object DescribeComplianceByResourceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.DescribeComplianceByResourceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.DescribeComplianceByResourceResponse =
      zio.aws.config.model.DescribeComplianceByResourceResponse(
        complianceByResources.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def complianceByResources
        : Option[List[zio.aws.config.model.ComplianceByResource.ReadOnly]]
    def nextToken: Option[NextToken]
    def getComplianceByResources: ZIO[Any, AwsError, List[
      zio.aws.config.model.ComplianceByResource.ReadOnly
    ]] =
      AwsError.unwrapOptionField("complianceByResources", complianceByResources)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.DescribeComplianceByResourceResponse
  ) extends zio.aws.config.model.DescribeComplianceByResourceResponse.ReadOnly {
    override val complianceByResources
        : Option[List[zio.aws.config.model.ComplianceByResource.ReadOnly]] =
      scala
        .Option(impl.complianceByResources())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.config.model.ComplianceByResource.wrap(item)
          }.toList
        )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.config.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.DescribeComplianceByResourceResponse
  ): zio.aws.config.model.DescribeComplianceByResourceResponse.ReadOnly =
    new Wrapper(impl)
}
