package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.config.model.primitives.NextToken
import scala.jdk.CollectionConverters.*
final case class DescribeAggregateComplianceByConfigRulesResponse(
    aggregateComplianceByConfigRules: Option[
      Iterable[zio.aws.config.model.AggregateComplianceByConfigRule]
    ] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.DescribeAggregateComplianceByConfigRulesResponse = {
    import DescribeAggregateComplianceByConfigRulesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.DescribeAggregateComplianceByConfigRulesResponse
      .builder()
      .optionallyWith(
        aggregateComplianceByConfigRules.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.aggregateComplianceByConfigRules)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.DescribeAggregateComplianceByConfigRulesResponse.ReadOnly =
    zio.aws.config.model.DescribeAggregateComplianceByConfigRulesResponse
      .wrap(buildAwsValue())
}
object DescribeAggregateComplianceByConfigRulesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.DescribeAggregateComplianceByConfigRulesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.config.model.DescribeAggregateComplianceByConfigRulesResponse =
      zio.aws.config.model.DescribeAggregateComplianceByConfigRulesResponse(
        aggregateComplianceByConfigRules.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def aggregateComplianceByConfigRules: Option[
      List[zio.aws.config.model.AggregateComplianceByConfigRule.ReadOnly]
    ]
    def nextToken: Option[NextToken]
    def getAggregateComplianceByConfigRules: ZIO[Any, AwsError, List[
      zio.aws.config.model.AggregateComplianceByConfigRule.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "aggregateComplianceByConfigRules",
      aggregateComplianceByConfigRules
    )
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.DescribeAggregateComplianceByConfigRulesResponse
  ) extends zio.aws.config.model.DescribeAggregateComplianceByConfigRulesResponse.ReadOnly {
    override val aggregateComplianceByConfigRules: Option[
      List[zio.aws.config.model.AggregateComplianceByConfigRule.ReadOnly]
    ] = scala
      .Option(impl.aggregateComplianceByConfigRules())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.config.model.AggregateComplianceByConfigRule.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.config.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.DescribeAggregateComplianceByConfigRulesResponse
  ): zio.aws.config.model.DescribeAggregateComplianceByConfigRulesResponse.ReadOnly =
    new Wrapper(impl)
}
