package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.config.model.primitives.{Date, AwsRegion, AccountId}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class AggregationAuthorization(
    aggregationAuthorizationArn: Option[String] = None,
    authorizedAccountId: Option[AccountId] = None,
    authorizedAwsRegion: Option[AwsRegion] = None,
    creationTime: Option[Date] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.AggregationAuthorization = {
    import AggregationAuthorization.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.AggregationAuthorization
      .builder()
      .optionallyWith(
        aggregationAuthorizationArn.map(value => value: java.lang.String)
      )(_.aggregationAuthorizationArn)
      .optionallyWith(
        authorizedAccountId.map(value =>
          AccountId.unwrap(value): java.lang.String
        )
      )(_.authorizedAccountId)
      .optionallyWith(
        authorizedAwsRegion.map(value =>
          AwsRegion.unwrap(value): java.lang.String
        )
      )(_.authorizedAwsRegion)
      .optionallyWith(creationTime.map(value => Date.unwrap(value): Instant))(
        _.creationTime
      )
      .build()
  }
  def asReadOnly: zio.aws.config.model.AggregationAuthorization.ReadOnly =
    zio.aws.config.model.AggregationAuthorization.wrap(buildAwsValue())
}
object AggregationAuthorization {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.AggregationAuthorization
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.AggregationAuthorization =
      zio.aws.config.model.AggregationAuthorization(
        aggregationAuthorizationArn.map(value => value),
        authorizedAccountId.map(value => value),
        authorizedAwsRegion.map(value => value),
        creationTime.map(value => value)
      )
    def aggregationAuthorizationArn: Option[String]
    def authorizedAccountId: Option[AccountId]
    def authorizedAwsRegion: Option[AwsRegion]
    def creationTime: Option[Date]
    def getAggregationAuthorizationArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "aggregationAuthorizationArn",
        aggregationAuthorizationArn
      )
    def getAuthorizedAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("authorizedAccountId", authorizedAccountId)
    def getAuthorizedAwsRegion: ZIO[Any, AwsError, AwsRegion] =
      AwsError.unwrapOptionField("authorizedAwsRegion", authorizedAwsRegion)
    def getCreationTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("creationTime", creationTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.AggregationAuthorization
  ) extends zio.aws.config.model.AggregationAuthorization.ReadOnly {
    override val aggregationAuthorizationArn: Option[String] = scala
      .Option(impl.aggregationAuthorizationArn())
      .map(value => value: String)
    override val authorizedAccountId: Option[AccountId] = scala
      .Option(impl.authorizedAccountId())
      .map(value => zio.aws.config.model.primitives.AccountId(value))
    override val authorizedAwsRegion: Option[AwsRegion] = scala
      .Option(impl.authorizedAwsRegion())
      .map(value => zio.aws.config.model.primitives.AwsRegion(value))
    override val creationTime: Option[Date] = scala
      .Option(impl.creationTime())
      .map(value => zio.aws.config.model.primitives.Date(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.AggregationAuthorization
  ): zio.aws.config.model.AggregationAuthorization.ReadOnly = new Wrapper(impl)
}
