package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.config.model.primitives.AccountId
import scala.jdk.CollectionConverters.*
final case class AccountAggregationSource(
    accountIds: Iterable[AccountId],
    allAwsRegions: Option[Boolean] = None,
    awsRegions: Option[Iterable[String]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.AccountAggregationSource = {
    import AccountAggregationSource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.AccountAggregationSource
      .builder()
      .accountIds(accountIds.map { item =>
        AccountId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(allAwsRegions.map(value => value: java.lang.Boolean))(
        _.allAwsRegions
      )
      .optionallyWith(
        awsRegions.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.awsRegions)
      .build()
  }
  def asReadOnly: zio.aws.config.model.AccountAggregationSource.ReadOnly =
    zio.aws.config.model.AccountAggregationSource.wrap(buildAwsValue())
}
object AccountAggregationSource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.AccountAggregationSource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.AccountAggregationSource =
      zio.aws.config.model.AccountAggregationSource(
        accountIds,
        allAwsRegions.map(value => value),
        awsRegions.map(value => value)
      )
    def accountIds: List[AccountId]
    def allAwsRegions: Option[Boolean]
    def awsRegions: Option[List[String]]
    def getAccountIds: ZIO[Any, Nothing, List[AccountId]] =
      ZIO.succeed(accountIds)
    def getAllAwsRegions: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("allAwsRegions", allAwsRegions)
    def getAwsRegions: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("awsRegions", awsRegions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.AccountAggregationSource
  ) extends zio.aws.config.model.AccountAggregationSource.ReadOnly {
    override val accountIds: List[AccountId] = impl
      .accountIds()
      .asScala
      .map { item =>
        zio.aws.config.model.primitives.AccountId(item)
      }
      .toList
    override val allAwsRegions: Option[Boolean] =
      scala.Option(impl.allAwsRegions()).map(value => value: Boolean)
    override val awsRegions: Option[List[String]] = scala
      .Option(impl.awsRegions())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.AccountAggregationSource
  ): zio.aws.config.model.AccountAggregationSource.ReadOnly = new Wrapper(impl)
}
