package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.config.model.primitives.AccountId
import scala.jdk.CollectionConverters.*
final case class StatusDetailFilters(
    accountId: Option[AccountId] = None,
    memberAccountRuleStatus: Option[
      zio.aws.config.model.MemberAccountRuleStatus
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.StatusDetailFilters = {
    import StatusDetailFilters.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.StatusDetailFilters
      .builder()
      .optionallyWith(
        accountId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.accountId)
      .optionallyWith(memberAccountRuleStatus.map(value => value.unwrap))(
        _.memberAccountRuleStatus
      )
      .build()
  }
  def asReadOnly: zio.aws.config.model.StatusDetailFilters.ReadOnly =
    zio.aws.config.model.StatusDetailFilters.wrap(buildAwsValue())
}
object StatusDetailFilters {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.StatusDetailFilters
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.StatusDetailFilters =
      zio.aws.config.model.StatusDetailFilters(
        accountId.map(value => value),
        memberAccountRuleStatus.map(value => value)
      )
    def accountId: Option[AccountId]
    def memberAccountRuleStatus
        : Option[zio.aws.config.model.MemberAccountRuleStatus]
    def getAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getMemberAccountRuleStatus
        : ZIO[Any, AwsError, zio.aws.config.model.MemberAccountRuleStatus] =
      AwsError.unwrapOptionField(
        "memberAccountRuleStatus",
        memberAccountRuleStatus
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.StatusDetailFilters
  ) extends zio.aws.config.model.StatusDetailFilters.ReadOnly {
    override val accountId: Option[AccountId] = scala
      .Option(impl.accountId())
      .map(value => zio.aws.config.model.primitives.AccountId(value))
    override val memberAccountRuleStatus
        : Option[zio.aws.config.model.MemberAccountRuleStatus] = scala
      .Option(impl.memberAccountRuleStatus())
      .map(value => zio.aws.config.model.MemberAccountRuleStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.StatusDetailFilters
  ): zio.aws.config.model.StatusDetailFilters.ReadOnly = new Wrapper(impl)
}
