package zio.aws.config.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.config.model.primitives.Percentage
import scala.jdk.CollectionConverters.*
final case class SsmControls(
    concurrentExecutionRatePercentage: Option[Percentage] = None,
    errorPercentage: Option[Percentage] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.SsmControls = {
    import SsmControls.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.SsmControls
      .builder()
      .optionallyWith(
        concurrentExecutionRatePercentage.map(value =>
          Percentage.unwrap(value): Integer
        )
      )(_.concurrentExecutionRatePercentage)
      .optionallyWith(
        errorPercentage.map(value => Percentage.unwrap(value): Integer)
      )(_.errorPercentage)
      .build()
  }
  def asReadOnly: zio.aws.config.model.SsmControls.ReadOnly =
    zio.aws.config.model.SsmControls.wrap(buildAwsValue())
}
object SsmControls {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.SsmControls
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.SsmControls =
      zio.aws.config.model.SsmControls(
        concurrentExecutionRatePercentage.map(value => value),
        errorPercentage.map(value => value)
      )
    def concurrentExecutionRatePercentage: Option[Percentage]
    def errorPercentage: Option[Percentage]
    def getConcurrentExecutionRatePercentage: ZIO[Any, AwsError, Percentage] =
      AwsError.unwrapOptionField(
        "concurrentExecutionRatePercentage",
        concurrentExecutionRatePercentage
      )
    def getErrorPercentage: ZIO[Any, AwsError, Percentage] =
      AwsError.unwrapOptionField("errorPercentage", errorPercentage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.SsmControls
  ) extends zio.aws.config.model.SsmControls.ReadOnly {
    override val concurrentExecutionRatePercentage: Option[Percentage] = scala
      .Option(impl.concurrentExecutionRatePercentage())
      .map(value => zio.aws.config.model.primitives.Percentage(value))
    override val errorPercentage: Option[Percentage] = scala
      .Option(impl.errorPercentage())
      .map(value => zio.aws.config.model.primitives.Percentage(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.SsmControls
  ): zio.aws.config.model.SsmControls.ReadOnly = new Wrapper(impl)
}
