package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetStoredQueryResponse(
    storedQuery: Option[zio.aws.config.model.StoredQuery] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.GetStoredQueryResponse = {
    import GetStoredQueryResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.GetStoredQueryResponse
      .builder()
      .optionallyWith(storedQuery.map(value => value.buildAwsValue()))(
        _.storedQuery
      )
      .build()
  }
  def asReadOnly: zio.aws.config.model.GetStoredQueryResponse.ReadOnly =
    zio.aws.config.model.GetStoredQueryResponse.wrap(buildAwsValue())
}
object GetStoredQueryResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.GetStoredQueryResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.GetStoredQueryResponse =
      zio.aws.config.model
        .GetStoredQueryResponse(storedQuery.map(value => value.asEditable))
    def storedQuery: Option[zio.aws.config.model.StoredQuery.ReadOnly]
    def getStoredQuery
        : ZIO[Any, AwsError, zio.aws.config.model.StoredQuery.ReadOnly] =
      AwsError.unwrapOptionField("storedQuery", storedQuery)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.GetStoredQueryResponse
  ) extends zio.aws.config.model.GetStoredQueryResponse.ReadOnly {
    override val storedQuery
        : Option[zio.aws.config.model.StoredQuery.ReadOnly] = scala
      .Option(impl.storedQuery())
      .map(value => zio.aws.config.model.StoredQuery.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.GetStoredQueryResponse
  ): zio.aws.config.model.GetStoredQueryResponse.ReadOnly = new Wrapper(impl)
}
