package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetOrganizationConformancePackDetailedStatusResponse(
    organizationConformancePackDetailedStatuses: Option[
      Iterable[zio.aws.config.model.OrganizationConformancePackDetailedStatus]
    ] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.GetOrganizationConformancePackDetailedStatusResponse = {
    import GetOrganizationConformancePackDetailedStatusResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.GetOrganizationConformancePackDetailedStatusResponse
      .builder()
      .optionallyWith(
        organizationConformancePackDetailedStatuses.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.organizationConformancePackDetailedStatuses)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.GetOrganizationConformancePackDetailedStatusResponse.ReadOnly =
    zio.aws.config.model.GetOrganizationConformancePackDetailedStatusResponse
      .wrap(buildAwsValue())
}
object GetOrganizationConformancePackDetailedStatusResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.GetOrganizationConformancePackDetailedStatusResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.config.model.GetOrganizationConformancePackDetailedStatusResponse =
      zio.aws.config.model.GetOrganizationConformancePackDetailedStatusResponse(
        organizationConformancePackDetailedStatuses.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def organizationConformancePackDetailedStatuses: Option[List[
      zio.aws.config.model.OrganizationConformancePackDetailedStatus.ReadOnly
    ]]
    def nextToken: Option[String]
    def getOrganizationConformancePackDetailedStatuses: ZIO[Any, AwsError, List[
      zio.aws.config.model.OrganizationConformancePackDetailedStatus.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "organizationConformancePackDetailedStatuses",
      organizationConformancePackDetailedStatuses
    )
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.GetOrganizationConformancePackDetailedStatusResponse
  ) extends zio.aws.config.model.GetOrganizationConformancePackDetailedStatusResponse.ReadOnly {
    override val organizationConformancePackDetailedStatuses: Option[List[
      zio.aws.config.model.OrganizationConformancePackDetailedStatus.ReadOnly
    ]] = scala
      .Option(impl.organizationConformancePackDetailedStatuses())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.config.model.OrganizationConformancePackDetailedStatus
            .wrap(item)
        }.toList
      )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.GetOrganizationConformancePackDetailedStatusResponse
  ): zio.aws.config.model.GetOrganizationConformancePackDetailedStatusResponse.ReadOnly =
    new Wrapper(impl)
}
