package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeOrganizationConformancePacksResponse(
    organizationConformancePacks: Option[
      Iterable[zio.aws.config.model.OrganizationConformancePack]
    ] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.DescribeOrganizationConformancePacksResponse = {
    import DescribeOrganizationConformancePacksResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.DescribeOrganizationConformancePacksResponse
      .builder()
      .optionallyWith(
        organizationConformancePacks.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.organizationConformancePacks)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.DescribeOrganizationConformancePacksResponse.ReadOnly =
    zio.aws.config.model.DescribeOrganizationConformancePacksResponse
      .wrap(buildAwsValue())
}
object DescribeOrganizationConformancePacksResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.DescribeOrganizationConformancePacksResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.config.model.DescribeOrganizationConformancePacksResponse =
      zio.aws.config.model.DescribeOrganizationConformancePacksResponse(
        organizationConformancePacks.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def organizationConformancePacks: Option[
      List[zio.aws.config.model.OrganizationConformancePack.ReadOnly]
    ]
    def nextToken: Option[String]
    def getOrganizationConformancePacks: ZIO[Any, AwsError, List[
      zio.aws.config.model.OrganizationConformancePack.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "organizationConformancePacks",
      organizationConformancePacks
    )
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.DescribeOrganizationConformancePacksResponse
  ) extends zio.aws.config.model.DescribeOrganizationConformancePacksResponse.ReadOnly {
    override val organizationConformancePacks: Option[
      List[zio.aws.config.model.OrganizationConformancePack.ReadOnly]
    ] = scala
      .Option(impl.organizationConformancePacks())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.config.model.OrganizationConformancePack.wrap(item)
        }.toList
      )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.DescribeOrganizationConformancePacksResponse
  ): zio.aws.config.model.DescribeOrganizationConformancePacksResponse.ReadOnly =
    new Wrapper(impl)
}
