package zio.aws.config.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.config.model.primitives.{
  CosmosPageLimit,
  OrganizationConformancePackName
}
import scala.jdk.CollectionConverters.*
final case class DescribeOrganizationConformancePackStatusesRequest(
    organizationConformancePackNames: Option[
      Iterable[OrganizationConformancePackName]
    ] = None,
    limit: Option[CosmosPageLimit] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.DescribeOrganizationConformancePackStatusesRequest = {
    import DescribeOrganizationConformancePackStatusesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.DescribeOrganizationConformancePackStatusesRequest
      .builder()
      .optionallyWith(
        organizationConformancePackNames.map(value =>
          value.map { item =>
            OrganizationConformancePackName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.organizationConformancePackNames)
      .optionallyWith(
        limit.map(value => CosmosPageLimit.unwrap(value): Integer)
      )(_.limit)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.DescribeOrganizationConformancePackStatusesRequest.ReadOnly =
    zio.aws.config.model.DescribeOrganizationConformancePackStatusesRequest
      .wrap(buildAwsValue())
}
object DescribeOrganizationConformancePackStatusesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.DescribeOrganizationConformancePackStatusesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.config.model.DescribeOrganizationConformancePackStatusesRequest =
      zio.aws.config.model.DescribeOrganizationConformancePackStatusesRequest(
        organizationConformancePackNames.map(value => value),
        limit.map(value => value),
        nextToken.map(value => value)
      )
    def organizationConformancePackNames
        : Option[List[OrganizationConformancePackName]]
    def limit: Option[CosmosPageLimit]
    def nextToken: Option[String]
    def getOrganizationConformancePackNames
        : ZIO[Any, AwsError, List[OrganizationConformancePackName]] =
      AwsError.unwrapOptionField(
        "organizationConformancePackNames",
        organizationConformancePackNames
      )
    def getLimit: ZIO[Any, AwsError, CosmosPageLimit] =
      AwsError.unwrapOptionField("limit", limit)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.DescribeOrganizationConformancePackStatusesRequest
  ) extends zio.aws.config.model.DescribeOrganizationConformancePackStatusesRequest.ReadOnly {
    override val organizationConformancePackNames
        : Option[List[OrganizationConformancePackName]] = scala
      .Option(impl.organizationConformancePackNames())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.config.model.primitives.OrganizationConformancePackName(item)
        }.toList
      )
    override val limit: Option[CosmosPageLimit] = scala
      .Option(impl.limit())
      .map(value => zio.aws.config.model.primitives.CosmosPageLimit(value))
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.DescribeOrganizationConformancePackStatusesRequest
  ): zio.aws.config.model.DescribeOrganizationConformancePackStatusesRequest.ReadOnly =
    new Wrapper(impl)
}
