package zio.aws.config.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.config.model.primitives.{
  NextToken,
  Limit,
  BaseResourceId,
  StringWithCharLimit256
}
import scala.jdk.CollectionConverters.*
final case class DescribeComplianceByResourceRequest(
    resourceType: Option[StringWithCharLimit256] = None,
    resourceId: Option[BaseResourceId] = None,
    complianceTypes: Option[Iterable[zio.aws.config.model.ComplianceType]] =
      None,
    limit: Option[Limit] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.DescribeComplianceByResourceRequest = {
    import DescribeComplianceByResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.DescribeComplianceByResourceRequest
      .builder()
      .optionallyWith(
        resourceType.map(value =>
          StringWithCharLimit256.unwrap(value): java.lang.String
        )
      )(_.resourceType)
      .optionallyWith(
        resourceId.map(value => BaseResourceId.unwrap(value): java.lang.String)
      )(_.resourceId)
      .optionallyWith(
        complianceTypes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.complianceTypesWithStrings)
      .optionallyWith(limit.map(value => Limit.unwrap(value): Integer))(_.limit)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.DescribeComplianceByResourceRequest.ReadOnly =
    zio.aws.config.model.DescribeComplianceByResourceRequest
      .wrap(buildAwsValue())
}
object DescribeComplianceByResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.DescribeComplianceByResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.DescribeComplianceByResourceRequest =
      zio.aws.config.model.DescribeComplianceByResourceRequest(
        resourceType.map(value => value),
        resourceId.map(value => value),
        complianceTypes.map(value => value),
        limit.map(value => value),
        nextToken.map(value => value)
      )
    def resourceType: Option[StringWithCharLimit256]
    def resourceId: Option[BaseResourceId]
    def complianceTypes: Option[List[zio.aws.config.model.ComplianceType]]
    def limit: Option[Limit]
    def nextToken: Option[NextToken]
    def getResourceType: ZIO[Any, AwsError, StringWithCharLimit256] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getResourceId: ZIO[Any, AwsError, BaseResourceId] =
      AwsError.unwrapOptionField("resourceId", resourceId)
    def getComplianceTypes
        : ZIO[Any, AwsError, List[zio.aws.config.model.ComplianceType]] =
      AwsError.unwrapOptionField("complianceTypes", complianceTypes)
    def getLimit: ZIO[Any, AwsError, Limit] =
      AwsError.unwrapOptionField("limit", limit)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.DescribeComplianceByResourceRequest
  ) extends zio.aws.config.model.DescribeComplianceByResourceRequest.ReadOnly {
    override val resourceType: Option[StringWithCharLimit256] = scala
      .Option(impl.resourceType())
      .map(value =>
        zio.aws.config.model.primitives.StringWithCharLimit256(value)
      )
    override val resourceId: Option[BaseResourceId] = scala
      .Option(impl.resourceId())
      .map(value => zio.aws.config.model.primitives.BaseResourceId(value))
    override val complianceTypes
        : Option[List[zio.aws.config.model.ComplianceType]] = scala
      .Option(impl.complianceTypes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.config.model.ComplianceType.wrap(item)
        }.toList
      )
    override val limit: Option[Limit] = scala
      .Option(impl.limit())
      .map(value => zio.aws.config.model.primitives.Limit(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.config.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.DescribeComplianceByResourceRequest
  ): zio.aws.config.model.DescribeComplianceByResourceRequest.ReadOnly =
    new Wrapper(impl)
}
