package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.config.model.primitives.{AwsRegion, AccountId, ConfigRuleName}
import scala.jdk.CollectionConverters.*
final case class ConfigRuleComplianceFilters(
    configRuleName: Option[ConfigRuleName] = None,
    complianceType: Option[zio.aws.config.model.ComplianceType] = None,
    accountId: Option[AccountId] = None,
    awsRegion: Option[AwsRegion] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.ConfigRuleComplianceFilters = {
    import ConfigRuleComplianceFilters.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.ConfigRuleComplianceFilters
      .builder()
      .optionallyWith(
        configRuleName.map(value =>
          ConfigRuleName.unwrap(value): java.lang.String
        )
      )(_.configRuleName)
      .optionallyWith(complianceType.map(value => value.unwrap))(
        _.complianceType
      )
      .optionallyWith(
        accountId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.accountId)
      .optionallyWith(
        awsRegion.map(value => AwsRegion.unwrap(value): java.lang.String)
      )(_.awsRegion)
      .build()
  }
  def asReadOnly: zio.aws.config.model.ConfigRuleComplianceFilters.ReadOnly =
    zio.aws.config.model.ConfigRuleComplianceFilters.wrap(buildAwsValue())
}
object ConfigRuleComplianceFilters {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.ConfigRuleComplianceFilters
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.ConfigRuleComplianceFilters =
      zio.aws.config.model.ConfigRuleComplianceFilters(
        configRuleName.map(value => value),
        complianceType.map(value => value),
        accountId.map(value => value),
        awsRegion.map(value => value)
      )
    def configRuleName: Option[ConfigRuleName]
    def complianceType: Option[zio.aws.config.model.ComplianceType]
    def accountId: Option[AccountId]
    def awsRegion: Option[AwsRegion]
    def getConfigRuleName: ZIO[Any, AwsError, ConfigRuleName] =
      AwsError.unwrapOptionField("configRuleName", configRuleName)
    def getComplianceType
        : ZIO[Any, AwsError, zio.aws.config.model.ComplianceType] =
      AwsError.unwrapOptionField("complianceType", complianceType)
    def getAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getAwsRegion: ZIO[Any, AwsError, AwsRegion] =
      AwsError.unwrapOptionField("awsRegion", awsRegion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.ConfigRuleComplianceFilters
  ) extends zio.aws.config.model.ConfigRuleComplianceFilters.ReadOnly {
    override val configRuleName: Option[ConfigRuleName] = scala
      .Option(impl.configRuleName())
      .map(value => zio.aws.config.model.primitives.ConfigRuleName(value))
    override val complianceType: Option[zio.aws.config.model.ComplianceType] =
      scala
        .Option(impl.complianceType())
        .map(value => zio.aws.config.model.ComplianceType.wrap(value))
    override val accountId: Option[AccountId] = scala
      .Option(impl.accountId())
      .map(value => zio.aws.config.model.primitives.AccountId(value))
    override val awsRegion: Option[AwsRegion] = scala
      .Option(impl.awsRegion())
      .map(value => zio.aws.config.model.primitives.AwsRegion(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.ConfigRuleComplianceFilters
  ): zio.aws.config.model.ConfigRuleComplianceFilters.ReadOnly = new Wrapper(
    impl
  )
}
