package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.config.model.primitives.StringWithCharLimit256
import scala.jdk.CollectionConverters.*
final case class Source(
    owner: zio.aws.config.model.Owner,
    sourceIdentifier: StringWithCharLimit256,
    sourceDetails: Option[Iterable[zio.aws.config.model.SourceDetail]] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.config.model.Source = {
    import Source.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.Source
      .builder()
      .owner(owner.unwrap)
      .sourceIdentifier(
        StringWithCharLimit256.unwrap(sourceIdentifier): java.lang.String
      )
      .optionallyWith(
        sourceDetails.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.sourceDetails)
      .build()
  }
  def asReadOnly: zio.aws.config.model.Source.ReadOnly =
    zio.aws.config.model.Source.wrap(buildAwsValue())
}
object Source {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.config.model.Source] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.Source = zio.aws.config.model.Source(
      owner,
      sourceIdentifier,
      sourceDetails.map(value =>
        value.map { item =>
          item.asEditable
        }
      )
    )
    def owner: zio.aws.config.model.Owner
    def sourceIdentifier: StringWithCharLimit256
    def sourceDetails: Option[List[zio.aws.config.model.SourceDetail.ReadOnly]]
    def getOwner: ZIO[Any, Nothing, zio.aws.config.model.Owner] =
      ZIO.succeed(owner)
    def getSourceIdentifier: ZIO[Any, Nothing, StringWithCharLimit256] =
      ZIO.succeed(sourceIdentifier)
    def getSourceDetails
        : ZIO[Any, AwsError, List[zio.aws.config.model.SourceDetail.ReadOnly]] =
      AwsError.unwrapOptionField("sourceDetails", sourceDetails)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.Source
  ) extends zio.aws.config.model.Source.ReadOnly {
    override val owner: zio.aws.config.model.Owner =
      zio.aws.config.model.Owner.wrap(impl.owner())
    override val sourceIdentifier: StringWithCharLimit256 =
      zio.aws.config.model.primitives
        .StringWithCharLimit256(impl.sourceIdentifier())
    override val sourceDetails
        : Option[List[zio.aws.config.model.SourceDetail.ReadOnly]] = scala
      .Option(impl.sourceDetails())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.config.model.SourceDetail.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.Source
  ): zio.aws.config.model.Source.ReadOnly = new Wrapper(impl)
}
