package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ResourceCount(
    resourceType: Option[zio.aws.config.model.ResourceType] = None,
    count: Option[Long] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.ResourceCount = {
    import ResourceCount.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.ResourceCount
      .builder()
      .optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType)
      .optionallyWith(count.map(value => value: java.lang.Long))(_.count)
      .build()
  }
  def asReadOnly: zio.aws.config.model.ResourceCount.ReadOnly =
    zio.aws.config.model.ResourceCount.wrap(buildAwsValue())
}
object ResourceCount {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.ResourceCount
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.ResourceCount =
      zio.aws.config.model.ResourceCount(
        resourceType.map(value => value),
        count.map(value => value)
      )
    def resourceType: Option[zio.aws.config.model.ResourceType]
    def count: Option[Long]
    def getResourceType: ZIO[Any, AwsError, zio.aws.config.model.ResourceType] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getCount: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("count", count)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.ResourceCount
  ) extends zio.aws.config.model.ResourceCount.ReadOnly {
    override val resourceType: Option[zio.aws.config.model.ResourceType] = scala
      .Option(impl.resourceType())
      .map(value => zio.aws.config.model.ResourceType.wrap(value))
    override val count: Option[Long] =
      scala.Option(impl.count()).map(value => value: Long)
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.ResourceCount
  ): zio.aws.config.model.ResourceCount.ReadOnly = new Wrapper(impl)
}
