package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.config.model.primitives.{
  Date,
  StringWithCharLimit1024,
  StringWithCharLimit256,
  ConfigRuleName
}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class RemediationException(
    configRuleName: ConfigRuleName,
    resourceType: StringWithCharLimit256,
    resourceId: StringWithCharLimit1024,
    message: Option[StringWithCharLimit1024] = None,
    expirationTime: Option[Date] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.RemediationException = {
    import RemediationException.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.RemediationException
      .builder()
      .configRuleName(ConfigRuleName.unwrap(configRuleName): java.lang.String)
      .resourceType(
        StringWithCharLimit256.unwrap(resourceType): java.lang.String
      )
      .resourceId(StringWithCharLimit1024.unwrap(resourceId): java.lang.String)
      .optionallyWith(
        message.map(value =>
          StringWithCharLimit1024.unwrap(value): java.lang.String
        )
      )(_.message)
      .optionallyWith(expirationTime.map(value => Date.unwrap(value): Instant))(
        _.expirationTime
      )
      .build()
  }
  def asReadOnly: zio.aws.config.model.RemediationException.ReadOnly =
    zio.aws.config.model.RemediationException.wrap(buildAwsValue())
}
object RemediationException {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.RemediationException
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.RemediationException =
      zio.aws.config.model.RemediationException(
        configRuleName,
        resourceType,
        resourceId,
        message.map(value => value),
        expirationTime.map(value => value)
      )
    def configRuleName: ConfigRuleName
    def resourceType: StringWithCharLimit256
    def resourceId: StringWithCharLimit1024
    def message: Option[StringWithCharLimit1024]
    def expirationTime: Option[Date]
    def getConfigRuleName: ZIO[Any, Nothing, ConfigRuleName] =
      ZIO.succeed(configRuleName)
    def getResourceType: ZIO[Any, Nothing, StringWithCharLimit256] =
      ZIO.succeed(resourceType)
    def getResourceId: ZIO[Any, Nothing, StringWithCharLimit1024] =
      ZIO.succeed(resourceId)
    def getMessage: ZIO[Any, AwsError, StringWithCharLimit1024] =
      AwsError.unwrapOptionField("message", message)
    def getExpirationTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("expirationTime", expirationTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.RemediationException
  ) extends zio.aws.config.model.RemediationException.ReadOnly {
    override val configRuleName: ConfigRuleName =
      zio.aws.config.model.primitives.ConfigRuleName(impl.configRuleName())
    override val resourceType: StringWithCharLimit256 =
      zio.aws.config.model.primitives
        .StringWithCharLimit256(impl.resourceType())
    override val resourceId: StringWithCharLimit1024 =
      zio.aws.config.model.primitives.StringWithCharLimit1024(impl.resourceId())
    override val message: Option[StringWithCharLimit1024] = scala
      .Option(impl.message())
      .map(value =>
        zio.aws.config.model.primitives.StringWithCharLimit1024(value)
      )
    override val expirationTime: Option[Date] = scala
      .Option(impl.expirationTime())
      .map(value => zio.aws.config.model.primitives.Date(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.RemediationException
  ): zio.aws.config.model.RemediationException.ReadOnly = new Wrapper(impl)
}
