package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.config.model.primitives.{
  IncludeGlobalResourceTypes,
  AllSupported
}
import scala.jdk.CollectionConverters.*
final case class RecordingGroup(
    allSupported: Option[AllSupported] = None,
    includeGlobalResourceTypes: Option[IncludeGlobalResourceTypes] = None,
    resourceTypes: Option[Iterable[zio.aws.config.model.ResourceType]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.RecordingGroup = {
    import RecordingGroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.RecordingGroup
      .builder()
      .optionallyWith(
        allSupported.map(value => AllSupported.unwrap(value): java.lang.Boolean)
      )(_.allSupported)
      .optionallyWith(
        includeGlobalResourceTypes.map(value =>
          IncludeGlobalResourceTypes.unwrap(value): java.lang.Boolean
        )
      )(_.includeGlobalResourceTypes)
      .optionallyWith(
        resourceTypes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.resourceTypesWithStrings)
      .build()
  }
  def asReadOnly: zio.aws.config.model.RecordingGroup.ReadOnly =
    zio.aws.config.model.RecordingGroup.wrap(buildAwsValue())
}
object RecordingGroup {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.RecordingGroup
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.RecordingGroup =
      zio.aws.config.model.RecordingGroup(
        allSupported.map(value => value),
        includeGlobalResourceTypes.map(value => value),
        resourceTypes.map(value => value)
      )
    def allSupported: Option[AllSupported]
    def includeGlobalResourceTypes: Option[IncludeGlobalResourceTypes]
    def resourceTypes: Option[List[zio.aws.config.model.ResourceType]]
    def getAllSupported: ZIO[Any, AwsError, AllSupported] =
      AwsError.unwrapOptionField("allSupported", allSupported)
    def getIncludeGlobalResourceTypes
        : ZIO[Any, AwsError, IncludeGlobalResourceTypes] =
      AwsError.unwrapOptionField(
        "includeGlobalResourceTypes",
        includeGlobalResourceTypes
      )
    def getResourceTypes
        : ZIO[Any, AwsError, List[zio.aws.config.model.ResourceType]] =
      AwsError.unwrapOptionField("resourceTypes", resourceTypes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.RecordingGroup
  ) extends zio.aws.config.model.RecordingGroup.ReadOnly {
    override val allSupported: Option[AllSupported] = scala
      .Option(impl.allSupported())
      .map(value => zio.aws.config.model.primitives.AllSupported(value))
    override val includeGlobalResourceTypes
        : Option[IncludeGlobalResourceTypes] = scala
      .Option(impl.includeGlobalResourceTypes())
      .map(value =>
        zio.aws.config.model.primitives.IncludeGlobalResourceTypes(value)
      )
    override val resourceTypes
        : Option[List[zio.aws.config.model.ResourceType]] = scala
      .Option(impl.resourceTypes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.config.model.ResourceType.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.RecordingGroup
  ): zio.aws.config.model.RecordingGroup.ReadOnly = new Wrapper(impl)
}
