package zio.aws.config.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class PutRemediationConfigurationsRequest(
    remediationConfigurations: Iterable[
      zio.aws.config.model.RemediationConfiguration
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.PutRemediationConfigurationsRequest = {
    import PutRemediationConfigurationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.PutRemediationConfigurationsRequest
      .builder()
      .remediationConfigurations(remediationConfigurations.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.PutRemediationConfigurationsRequest.ReadOnly =
    zio.aws.config.model.PutRemediationConfigurationsRequest
      .wrap(buildAwsValue())
}
object PutRemediationConfigurationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.PutRemediationConfigurationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.PutRemediationConfigurationsRequest =
      zio.aws.config.model.PutRemediationConfigurationsRequest(
        remediationConfigurations.map { item =>
          item.asEditable
        }
      )
    def remediationConfigurations
        : List[zio.aws.config.model.RemediationConfiguration.ReadOnly]
    def getRemediationConfigurations: ZIO[Any, Nothing, List[
      zio.aws.config.model.RemediationConfiguration.ReadOnly
    ]] = ZIO.succeed(remediationConfigurations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.PutRemediationConfigurationsRequest
  ) extends zio.aws.config.model.PutRemediationConfigurationsRequest.ReadOnly {
    override val remediationConfigurations
        : List[zio.aws.config.model.RemediationConfiguration.ReadOnly] = impl
      .remediationConfigurations()
      .asScala
      .map { item =>
        zio.aws.config.model.RemediationConfiguration.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.PutRemediationConfigurationsRequest
  ): zio.aws.config.model.PutRemediationConfigurationsRequest.ReadOnly =
    new Wrapper(impl)
}
