package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.config.model.primitives.{
  DeliveryS3KeyPrefix,
  OrganizationConformancePackName,
  DeliveryS3Bucket,
  AccountId,
  TemplateS3Uri,
  TemplateBody
}
import scala.jdk.CollectionConverters.*
final case class PutOrganizationConformancePackRequest(
    organizationConformancePackName: OrganizationConformancePackName,
    templateS3Uri: Option[TemplateS3Uri] = None,
    templateBody: Option[TemplateBody] = None,
    deliveryS3Bucket: Option[DeliveryS3Bucket] = None,
    deliveryS3KeyPrefix: Option[DeliveryS3KeyPrefix] = None,
    conformancePackInputParameters: Option[
      Iterable[zio.aws.config.model.ConformancePackInputParameter]
    ] = None,
    excludedAccounts: Option[Iterable[AccountId]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.PutOrganizationConformancePackRequest = {
    import PutOrganizationConformancePackRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.PutOrganizationConformancePackRequest
      .builder()
      .organizationConformancePackName(
        OrganizationConformancePackName.unwrap(
          organizationConformancePackName
        ): java.lang.String
      )
      .optionallyWith(
        templateS3Uri.map(value =>
          TemplateS3Uri.unwrap(value): java.lang.String
        )
      )(_.templateS3Uri)
      .optionallyWith(
        templateBody.map(value => TemplateBody.unwrap(value): java.lang.String)
      )(_.templateBody)
      .optionallyWith(
        deliveryS3Bucket.map(value =>
          DeliveryS3Bucket.unwrap(value): java.lang.String
        )
      )(_.deliveryS3Bucket)
      .optionallyWith(
        deliveryS3KeyPrefix.map(value =>
          DeliveryS3KeyPrefix.unwrap(value): java.lang.String
        )
      )(_.deliveryS3KeyPrefix)
      .optionallyWith(
        conformancePackInputParameters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.conformancePackInputParameters)
      .optionallyWith(
        excludedAccounts.map(value =>
          value.map { item =>
            AccountId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.excludedAccounts)
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.PutOrganizationConformancePackRequest.ReadOnly =
    zio.aws.config.model.PutOrganizationConformancePackRequest
      .wrap(buildAwsValue())
}
object PutOrganizationConformancePackRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.PutOrganizationConformancePackRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.PutOrganizationConformancePackRequest =
      zio.aws.config.model.PutOrganizationConformancePackRequest(
        organizationConformancePackName,
        templateS3Uri.map(value => value),
        templateBody.map(value => value),
        deliveryS3Bucket.map(value => value),
        deliveryS3KeyPrefix.map(value => value),
        conformancePackInputParameters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        excludedAccounts.map(value => value)
      )
    def organizationConformancePackName: OrganizationConformancePackName
    def templateS3Uri: Option[TemplateS3Uri]
    def templateBody: Option[TemplateBody]
    def deliveryS3Bucket: Option[DeliveryS3Bucket]
    def deliveryS3KeyPrefix: Option[DeliveryS3KeyPrefix]
    def conformancePackInputParameters: Option[
      List[zio.aws.config.model.ConformancePackInputParameter.ReadOnly]
    ]
    def excludedAccounts: Option[List[AccountId]]
    def getOrganizationConformancePackName
        : ZIO[Any, Nothing, OrganizationConformancePackName] =
      ZIO.succeed(organizationConformancePackName)
    def getTemplateS3Uri: ZIO[Any, AwsError, TemplateS3Uri] =
      AwsError.unwrapOptionField("templateS3Uri", templateS3Uri)
    def getTemplateBody: ZIO[Any, AwsError, TemplateBody] =
      AwsError.unwrapOptionField("templateBody", templateBody)
    def getDeliveryS3Bucket: ZIO[Any, AwsError, DeliveryS3Bucket] =
      AwsError.unwrapOptionField("deliveryS3Bucket", deliveryS3Bucket)
    def getDeliveryS3KeyPrefix: ZIO[Any, AwsError, DeliveryS3KeyPrefix] =
      AwsError.unwrapOptionField("deliveryS3KeyPrefix", deliveryS3KeyPrefix)
    def getConformancePackInputParameters: ZIO[Any, AwsError, List[
      zio.aws.config.model.ConformancePackInputParameter.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "conformancePackInputParameters",
      conformancePackInputParameters
    )
    def getExcludedAccounts: ZIO[Any, AwsError, List[AccountId]] =
      AwsError.unwrapOptionField("excludedAccounts", excludedAccounts)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.PutOrganizationConformancePackRequest
  ) extends zio.aws.config.model.PutOrganizationConformancePackRequest.ReadOnly {
    override val organizationConformancePackName
        : OrganizationConformancePackName = zio.aws.config.model.primitives
      .OrganizationConformancePackName(impl.organizationConformancePackName())
    override val templateS3Uri: Option[TemplateS3Uri] = scala
      .Option(impl.templateS3Uri())
      .map(value => zio.aws.config.model.primitives.TemplateS3Uri(value))
    override val templateBody: Option[TemplateBody] = scala
      .Option(impl.templateBody())
      .map(value => zio.aws.config.model.primitives.TemplateBody(value))
    override val deliveryS3Bucket: Option[DeliveryS3Bucket] = scala
      .Option(impl.deliveryS3Bucket())
      .map(value => zio.aws.config.model.primitives.DeliveryS3Bucket(value))
    override val deliveryS3KeyPrefix: Option[DeliveryS3KeyPrefix] = scala
      .Option(impl.deliveryS3KeyPrefix())
      .map(value => zio.aws.config.model.primitives.DeliveryS3KeyPrefix(value))
    override val conformancePackInputParameters: Option[
      List[zio.aws.config.model.ConformancePackInputParameter.ReadOnly]
    ] = scala
      .Option(impl.conformancePackInputParameters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.config.model.ConformancePackInputParameter.wrap(item)
        }.toList
      )
    override val excludedAccounts: Option[List[AccountId]] = scala
      .Option(impl.excludedAccounts())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.config.model.primitives.AccountId(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.PutOrganizationConformancePackRequest
  ): zio.aws.config.model.PutOrganizationConformancePackRequest.ReadOnly =
    new Wrapper(impl)
}
