package zio.aws.config.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.config.model.primitives.{NextToken, Limit, StringWithCharLimit64}
import scala.jdk.CollectionConverters.*
final case class GetComplianceDetailsByConfigRuleRequest(
    configRuleName: StringWithCharLimit64,
    complianceTypes: Option[Iterable[zio.aws.config.model.ComplianceType]] =
      None,
    limit: Option[Limit] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.GetComplianceDetailsByConfigRuleRequest = {
    import GetComplianceDetailsByConfigRuleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.GetComplianceDetailsByConfigRuleRequest
      .builder()
      .configRuleName(
        StringWithCharLimit64.unwrap(configRuleName): java.lang.String
      )
      .optionallyWith(
        complianceTypes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.complianceTypesWithStrings)
      .optionallyWith(limit.map(value => Limit.unwrap(value): Integer))(_.limit)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.GetComplianceDetailsByConfigRuleRequest.ReadOnly =
    zio.aws.config.model.GetComplianceDetailsByConfigRuleRequest
      .wrap(buildAwsValue())
}
object GetComplianceDetailsByConfigRuleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.GetComplianceDetailsByConfigRuleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.config.model.GetComplianceDetailsByConfigRuleRequest =
      zio.aws.config.model.GetComplianceDetailsByConfigRuleRequest(
        configRuleName,
        complianceTypes.map(value => value),
        limit.map(value => value),
        nextToken.map(value => value)
      )
    def configRuleName: StringWithCharLimit64
    def complianceTypes: Option[List[zio.aws.config.model.ComplianceType]]
    def limit: Option[Limit]
    def nextToken: Option[NextToken]
    def getConfigRuleName: ZIO[Any, Nothing, StringWithCharLimit64] =
      ZIO.succeed(configRuleName)
    def getComplianceTypes
        : ZIO[Any, AwsError, List[zio.aws.config.model.ComplianceType]] =
      AwsError.unwrapOptionField("complianceTypes", complianceTypes)
    def getLimit: ZIO[Any, AwsError, Limit] =
      AwsError.unwrapOptionField("limit", limit)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.GetComplianceDetailsByConfigRuleRequest
  ) extends zio.aws.config.model.GetComplianceDetailsByConfigRuleRequest.ReadOnly {
    override val configRuleName: StringWithCharLimit64 =
      zio.aws.config.model.primitives
        .StringWithCharLimit64(impl.configRuleName())
    override val complianceTypes
        : Option[List[zio.aws.config.model.ComplianceType]] = scala
      .Option(impl.complianceTypes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.config.model.ComplianceType.wrap(item)
        }.toList
      )
    override val limit: Option[Limit] = scala
      .Option(impl.limit())
      .map(value => zio.aws.config.model.primitives.Limit(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.config.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.GetComplianceDetailsByConfigRuleRequest
  ): zio.aws.config.model.GetComplianceDetailsByConfigRuleRequest.ReadOnly =
    new Wrapper(impl)
}
