package zio.aws.config.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.config.model.primitives.ConfigurationAggregatorName
import scala.jdk.CollectionConverters.*
final case class GetAggregateResourceConfigRequest(
    configurationAggregatorName: ConfigurationAggregatorName,
    resourceIdentifier: zio.aws.config.model.AggregateResourceIdentifier
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.GetAggregateResourceConfigRequest = {
    import GetAggregateResourceConfigRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.GetAggregateResourceConfigRequest
      .builder()
      .configurationAggregatorName(
        ConfigurationAggregatorName.unwrap(
          configurationAggregatorName
        ): java.lang.String
      )
      .resourceIdentifier(resourceIdentifier.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.GetAggregateResourceConfigRequest.ReadOnly =
    zio.aws.config.model.GetAggregateResourceConfigRequest.wrap(buildAwsValue())
}
object GetAggregateResourceConfigRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.GetAggregateResourceConfigRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.GetAggregateResourceConfigRequest =
      zio.aws.config.model.GetAggregateResourceConfigRequest(
        configurationAggregatorName,
        resourceIdentifier.asEditable
      )
    def configurationAggregatorName: ConfigurationAggregatorName
    def resourceIdentifier
        : zio.aws.config.model.AggregateResourceIdentifier.ReadOnly
    def getConfigurationAggregatorName
        : ZIO[Any, Nothing, ConfigurationAggregatorName] =
      ZIO.succeed(configurationAggregatorName)
    def getResourceIdentifier: ZIO[
      Any,
      Nothing,
      zio.aws.config.model.AggregateResourceIdentifier.ReadOnly
    ] = ZIO.succeed(resourceIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.GetAggregateResourceConfigRequest
  ) extends zio.aws.config.model.GetAggregateResourceConfigRequest.ReadOnly {
    override val configurationAggregatorName: ConfigurationAggregatorName =
      zio.aws.config.model.primitives
        .ConfigurationAggregatorName(impl.configurationAggregatorName())
    override val resourceIdentifier
        : zio.aws.config.model.AggregateResourceIdentifier.ReadOnly =
      zio.aws.config.model.AggregateResourceIdentifier
        .wrap(impl.resourceIdentifier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.GetAggregateResourceConfigRequest
  ): zio.aws.config.model.GetAggregateResourceConfigRequest.ReadOnly =
    new Wrapper(impl)
}
