package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.config.model.primitives.{NextToken, StringWithCharLimit256}
import scala.jdk.CollectionConverters.*
final case class GetAggregateConformancePackComplianceSummaryResponse(
    aggregateConformancePackComplianceSummaries: Option[
      Iterable[zio.aws.config.model.AggregateConformancePackComplianceSummary]
    ] = None,
    groupByKey: Option[StringWithCharLimit256] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.GetAggregateConformancePackComplianceSummaryResponse = {
    import GetAggregateConformancePackComplianceSummaryResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.GetAggregateConformancePackComplianceSummaryResponse
      .builder()
      .optionallyWith(
        aggregateConformancePackComplianceSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.aggregateConformancePackComplianceSummaries)
      .optionallyWith(
        groupByKey.map(value =>
          StringWithCharLimit256.unwrap(value): java.lang.String
        )
      )(_.groupByKey)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.GetAggregateConformancePackComplianceSummaryResponse.ReadOnly =
    zio.aws.config.model.GetAggregateConformancePackComplianceSummaryResponse
      .wrap(buildAwsValue())
}
object GetAggregateConformancePackComplianceSummaryResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.GetAggregateConformancePackComplianceSummaryResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.config.model.GetAggregateConformancePackComplianceSummaryResponse =
      zio.aws.config.model.GetAggregateConformancePackComplianceSummaryResponse(
        aggregateConformancePackComplianceSummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        groupByKey.map(value => value),
        nextToken.map(value => value)
      )
    def aggregateConformancePackComplianceSummaries: Option[List[
      zio.aws.config.model.AggregateConformancePackComplianceSummary.ReadOnly
    ]]
    def groupByKey: Option[StringWithCharLimit256]
    def nextToken: Option[NextToken]
    def getAggregateConformancePackComplianceSummaries: ZIO[Any, AwsError, List[
      zio.aws.config.model.AggregateConformancePackComplianceSummary.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "aggregateConformancePackComplianceSummaries",
      aggregateConformancePackComplianceSummaries
    )
    def getGroupByKey: ZIO[Any, AwsError, StringWithCharLimit256] =
      AwsError.unwrapOptionField("groupByKey", groupByKey)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.GetAggregateConformancePackComplianceSummaryResponse
  ) extends zio.aws.config.model.GetAggregateConformancePackComplianceSummaryResponse.ReadOnly {
    override val aggregateConformancePackComplianceSummaries: Option[List[
      zio.aws.config.model.AggregateConformancePackComplianceSummary.ReadOnly
    ]] = scala
      .Option(impl.aggregateConformancePackComplianceSummaries())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.config.model.AggregateConformancePackComplianceSummary
            .wrap(item)
        }.toList
      )
    override val groupByKey: Option[StringWithCharLimit256] = scala
      .Option(impl.groupByKey())
      .map(value =>
        zio.aws.config.model.primitives.StringWithCharLimit256(value)
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.config.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.GetAggregateConformancePackComplianceSummaryResponse
  ): zio.aws.config.model.GetAggregateConformancePackComplianceSummaryResponse.ReadOnly =
    new Wrapper(impl)
}
