package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.config.model.primitives.{
  OrderingTimestamp,
  BaseResourceId,
  StringWithCharLimit256
}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class Evaluation(
    complianceResourceType: StringWithCharLimit256,
    complianceResourceId: BaseResourceId,
    complianceType: zio.aws.config.model.ComplianceType,
    annotation: Option[StringWithCharLimit256] = None,
    orderingTimestamp: OrderingTimestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.Evaluation = {
    import Evaluation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.Evaluation
      .builder()
      .complianceResourceType(
        StringWithCharLimit256.unwrap(complianceResourceType): java.lang.String
      )
      .complianceResourceId(
        BaseResourceId.unwrap(complianceResourceId): java.lang.String
      )
      .complianceType(complianceType.unwrap)
      .optionallyWith(
        annotation.map(value =>
          StringWithCharLimit256.unwrap(value): java.lang.String
        )
      )(_.annotation)
      .orderingTimestamp(OrderingTimestamp.unwrap(orderingTimestamp): Instant)
      .build()
  }
  def asReadOnly: zio.aws.config.model.Evaluation.ReadOnly =
    zio.aws.config.model.Evaluation.wrap(buildAwsValue())
}
object Evaluation {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.config.model.Evaluation] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.Evaluation =
      zio.aws.config.model.Evaluation(
        complianceResourceType,
        complianceResourceId,
        complianceType,
        annotation.map(value => value),
        orderingTimestamp
      )
    def complianceResourceType: StringWithCharLimit256
    def complianceResourceId: BaseResourceId
    def complianceType: zio.aws.config.model.ComplianceType
    def annotation: Option[StringWithCharLimit256]
    def orderingTimestamp: OrderingTimestamp
    def getComplianceResourceType: ZIO[Any, Nothing, StringWithCharLimit256] =
      ZIO.succeed(complianceResourceType)
    def getComplianceResourceId: ZIO[Any, Nothing, BaseResourceId] =
      ZIO.succeed(complianceResourceId)
    def getComplianceType
        : ZIO[Any, Nothing, zio.aws.config.model.ComplianceType] =
      ZIO.succeed(complianceType)
    def getAnnotation: ZIO[Any, AwsError, StringWithCharLimit256] =
      AwsError.unwrapOptionField("annotation", annotation)
    def getOrderingTimestamp: ZIO[Any, Nothing, OrderingTimestamp] =
      ZIO.succeed(orderingTimestamp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.Evaluation
  ) extends zio.aws.config.model.Evaluation.ReadOnly {
    override val complianceResourceType: StringWithCharLimit256 =
      zio.aws.config.model.primitives
        .StringWithCharLimit256(impl.complianceResourceType())
    override val complianceResourceId: BaseResourceId =
      zio.aws.config.model.primitives
        .BaseResourceId(impl.complianceResourceId())
    override val complianceType: zio.aws.config.model.ComplianceType =
      zio.aws.config.model.ComplianceType.wrap(impl.complianceType())
    override val annotation: Option[StringWithCharLimit256] = scala
      .Option(impl.annotation())
      .map(value =>
        zio.aws.config.model.primitives.StringWithCharLimit256(value)
      )
    override val orderingTimestamp: OrderingTimestamp =
      zio.aws.config.model.primitives
        .OrderingTimestamp(impl.orderingTimestamp())
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.Evaluation
  ): zio.aws.config.model.Evaluation.ReadOnly = new Wrapper(impl)
}
