package zio.aws.config.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeDeliveryChannelStatusResponse(
    deliveryChannelsStatus: Option[
      Iterable[zio.aws.config.model.DeliveryChannelStatus]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.config.model.DescribeDeliveryChannelStatusResponse = {
    import DescribeDeliveryChannelStatusResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.config.model.DescribeDeliveryChannelStatusResponse
      .builder()
      .optionallyWith(
        deliveryChannelsStatus.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.deliveryChannelsStatus)
      .build()
  }
  def asReadOnly
      : zio.aws.config.model.DescribeDeliveryChannelStatusResponse.ReadOnly =
    zio.aws.config.model.DescribeDeliveryChannelStatusResponse
      .wrap(buildAwsValue())
}
object DescribeDeliveryChannelStatusResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.config.model.DescribeDeliveryChannelStatusResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.config.model.DescribeDeliveryChannelStatusResponse =
      zio.aws.config.model.DescribeDeliveryChannelStatusResponse(
        deliveryChannelsStatus.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def deliveryChannelsStatus
        : Option[List[zio.aws.config.model.DeliveryChannelStatus.ReadOnly]]
    def getDeliveryChannelsStatus: ZIO[Any, AwsError, List[
      zio.aws.config.model.DeliveryChannelStatus.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "deliveryChannelsStatus",
      deliveryChannelsStatus
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.config.model.DescribeDeliveryChannelStatusResponse
  ) extends zio.aws.config.model.DescribeDeliveryChannelStatusResponse.ReadOnly {
    override val deliveryChannelsStatus
        : Option[List[zio.aws.config.model.DeliveryChannelStatus.ReadOnly]] =
      scala
        .Option(impl.deliveryChannelsStatus())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.config.model.DeliveryChannelStatus.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.config.model.DescribeDeliveryChannelStatusResponse
  ): zio.aws.config.model.DescribeDeliveryChannelStatusResponse.ReadOnly =
    new Wrapper(impl)
}
